<?php
/**
 * Plugin Name: INX theme settings
 * Description: It will contain all theme settings
 * Version: 1.0.0
 * Author: INX development team
 */
 
add_action('admin_menu', 'fonix_settings');

function fonix_settings() {
	add_menu_page('Contact Settings', 'Contact Settings', 'administrator', 'inx-settings-info', 'inx_theme_settings', 'dashicons-admin-generic');
}

function inx_theme_settings() { ?>
  <div class="wrap">
<h2>Theme settings</h2>
<form method="post" action="options.php">
    <?php settings_fields( 'inx-theme-settings-group' ); ?>
    <?php do_settings_sections( 'inx-theme-settings-group' ); ?>
    <table class="form-table">
        <tr valign="top">
            <th scope="row">Header section</th>
        </tr>
        <tr valign="top">
            <th scope="row">Phone Number</th>
            <td><input type="text" name="inx_phone_num" value="<?php echo esc_attr( get_option('inx_phone_num') ); ?>" required/></td>
        </tr>

         <tr valign="top">
            <th scope="row">Alternative Phone Number</th>
            <td><input type="text" name="inx_alt_phone_num" value="<?php echo esc_attr( get_option('inx_alt_phone_num') ); ?>" required/></td>
        </tr>

        <tr valign="top">
            <th scope="row">Contact Email</th>
            <td><input type="email" name="inx_contact_email" value="<?php echo esc_attr( get_option('inx_contact_email') ); ?>" required/></td>
        </tr>

        <tr valign="top">
            <th scope="row">HR Email</th>
            <td><input type="email" name="inx_hr_email" value="<?php echo esc_attr( get_option('inx_hr_email') ); ?>" required/></td>
        </tr>
    </table>
    
    <?php submit_button(); ?>

</form>
</div>
<?php
}

add_action( 'admin_init', 'inx_group_settings' );

function inx_group_settings() {
    register_setting( 'inx-theme-settings-group', 'inx_phone_num' );
    register_setting( 'inx-theme-settings-group', 'inx_alt_phone_num' );
    register_setting( 'inx-theme-settings-group', 'inx_contact_email' );
    register_setting( 'inx-theme-settings-group', 'inx_hr_email' );
}