<?php
/**
 * Twenty Nineteen functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package WordPress
 * @subpackage Twenty_Nineteen
 * @since 1.0.0
 */

/**
 * Twenty Nineteen only works in WordPress 4.7 or later.
 */
if ( version_compare( $GLOBALS['wp_version'], '4.7', '<' ) ) {
	require get_template_directory() . '/inc/back-compat.php';
	return;
}

if ( ! function_exists( 'twentynineteen_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function twentynineteen_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on Twenty Nineteen, use a find and replace
		 * to change 'twentynineteen' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'twentynineteen', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );
		set_post_thumbnail_size( 1568, 9999 );

		// This theme uses wp_nav_menu() in two locations.
		register_nav_menus(
			array(
				'menu-1' => __( 'Primary', 'twentynineteen' ),
				'footer' => __( 'Footer Menu', 'twentynineteen' ),
				'social' => __( 'Social Links Menu', 'twentynineteen' ),
			)
		);

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
			)
		);

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 190,
				'width'       => 190,
				'flex-width'  => false,
				'flex-height' => false,
			)
		);

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		// Add support for Block Styles.
		add_theme_support( 'wp-block-styles' );

		// Add support for full and wide align images.
		add_theme_support( 'align-wide' );

		// Add support for editor styles.
		add_theme_support( 'editor-styles' );

		// Enqueue editor styles.
		add_editor_style( 'style-editor.css' );

		// Add custom editor font sizes.
		add_theme_support(
			'editor-font-sizes',
			array(
				array(
					'name'      => __( 'Small', 'twentynineteen' ),
					'shortName' => __( 'S', 'twentynineteen' ),
					'size'      => 19.5,
					'slug'      => 'small',
				),
				array(
					'name'      => __( 'Normal', 'twentynineteen' ),
					'shortName' => __( 'M', 'twentynineteen' ),
					'size'      => 22,
					'slug'      => 'normal',
				),
				array(
					'name'      => __( 'Large', 'twentynineteen' ),
					'shortName' => __( 'L', 'twentynineteen' ),
					'size'      => 36.5,
					'slug'      => 'large',
				),
				array(
					'name'      => __( 'Huge', 'twentynineteen' ),
					'shortName' => __( 'XL', 'twentynineteen' ),
					'size'      => 49.5,
					'slug'      => 'huge',
				),
			)
		);

		// Editor color palette.
		add_theme_support(
			'editor-color-palette',
			array(
				array(
					'name'  => __( 'Primary', 'twentynineteen' ),
					'slug'  => 'primary',
					'color' => twentynineteen_hsl_hex( 'default' === get_theme_mod( 'primary_color' ) ? 199 : get_theme_mod( 'primary_color_hue', 199 ), 100, 33 ),
				),
				array(
					'name'  => __( 'Secondary', 'twentynineteen' ),
					'slug'  => 'secondary',
					'color' => twentynineteen_hsl_hex( 'default' === get_theme_mod( 'primary_color' ) ? 199 : get_theme_mod( 'primary_color_hue', 199 ), 100, 23 ),
				),
				array(
					'name'  => __( 'Dark Gray', 'twentynineteen' ),
					'slug'  => 'dark-gray',
					'color' => '#111',
				),
				array(
					'name'  => __( 'Light Gray', 'twentynineteen' ),
					'slug'  => 'light-gray',
					'color' => '#767676',
				),
				array(
					'name'  => __( 'White', 'twentynineteen' ),
					'slug'  => 'white',
					'color' => '#FFF',
				),
			)
		);

		// Add support for responsive embedded content.
		add_theme_support( 'responsive-embeds' );
	}
endif;
add_action( 'after_setup_theme', 'twentynineteen_setup' );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function twentynineteen_widgets_init() {

	register_sidebar(
		array(
			'name'          => __( 'Footer', 'twentynineteen' ),
			'id'            => 'sidebar-1',
			'description'   => __( 'Add widgets here to appear in your footer.', 'twentynineteen' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);

}
add_action( 'widgets_init', 'twentynineteen_widgets_init' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width Content width.
 */
function twentynineteen_content_width() {
	// This variable is intended to be overruled from themes.
	// Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
	// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	$GLOBALS['content_width'] = apply_filters( 'twentynineteen_content_width', 640 );
}
add_action( 'after_setup_theme', 'twentynineteen_content_width', 0 );

// function unsubscribe()
// {
// 	$email=$_GET['email'];
// 	global $wpdb;
//     $table_name = $wpdb->prefix.'inx_subscription';
//     if ($email) {
//     	$wpdb->query("UPDATE $table_name SET type='0' WHERE email='$email'");
//      	echo "You have unsubscribed successfully!";
//      	$url='https://inheritx.com/';
//      	//wp_redirect( $url );
//      	header("Location: https://inheritx.com/"); 
// 		exit;
//      }
// 	//return $url;
// }
// unsubscribe();

function unsubscribe() {
    if (isset($_GET['email'])) {
        $email = $_GET['email'];
        global $wpdb;
        $table_name = $wpdb->prefix.'inx_subscription';
        $wpdb->query("UPDATE $table_name SET type='0' WHERE email='$email'");
        echo "You have unsubscribed successfully!";
        $url = 'https://inheritx.com/';
        //wp_redirect( $url );
        header("Location: $url");
        exit;
    }
}

unsubscribe();


/**
 * Enqueue scripts and styles.
 */
function twentynineteen_scripts() {
	wp_enqueue_style( 'twentynineteen-style', get_stylesheet_uri(), array(), wp_get_theme()->get( 'Version' ) );

	wp_style_add_data( 'twentynineteen-style', 'rtl', 'replace' );

	if ( has_nav_menu( 'menu-1' ) ) {
		wp_enqueue_script( 'twentynineteen-priority-menu', get_theme_file_uri( '/js/priority-menu.js' ), array(), '1.1', true );
		wp_enqueue_script( 'twentynineteen-touch-navigation', get_theme_file_uri( '/js/touch-keyboard-navigation.js' ), array(), '1.1', true );
	}

	wp_enqueue_style( 'twentynineteen-print-style', get_template_directory_uri() . '/print.css', array(), wp_get_theme()->get( 'Version' ), 'print' );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'twentynineteen_scripts' );

/**
 * Fix skip link focus in IE11.
 *
 * This does not enqueue the script because it is tiny and because it is only for IE11,
 * thus it does not warrant having an entire dedicated blocking script being loaded.
 *
 * @link https://git.io/vWdr2
 */
function twentynineteen_skip_link_focus_fix() {
	// The following is minified via `terser --compress --mangle -- js/skip-link-focus-fix.js`.
	?>
	<script>
	/(trident|msie)/i.test(navigator.userAgent)&&document.getElementById&&window.addEventListener&&window.addEventListener("hashchange",function(){var t,e=location.hash.substring(1);/^[A-z0-9_-]+$/.test(e)&&(t=document.getElementById(e))&&(/^(?:a|select|input|button|textarea)$/i.test(t.tagName)||(t.tabIndex=-1),t.focus())},!1);
	</script>
	<?php
}
add_action( 'wp_print_footer_scripts', 'twentynineteen_skip_link_focus_fix' );

/**
 * Enqueue supplemental block editor styles.
 */
function twentynineteen_editor_customizer_styles() {

	wp_enqueue_style( 'twentynineteen-editor-customizer-styles', get_theme_file_uri( '/style-editor-customizer.css' ), false, '1.1', 'all' );

	if ( 'custom' === get_theme_mod( 'primary_color' ) ) {
		// Include color patterns.
		require_once get_parent_theme_file_path( '/inc/color-patterns.php' );
		wp_add_inline_style( 'twentynineteen-editor-customizer-styles', twentynineteen_custom_colors_css() );
	}
}
add_action( 'enqueue_block_editor_assets', 'twentynineteen_editor_customizer_styles' );

/**
 * Display custom color CSS in customizer and on frontend.
 */
function twentynineteen_colors_css_wrap() {

	// Only include custom colors in customizer or frontend.
	if ( ( ! is_customize_preview() && 'default' === get_theme_mod( 'primary_color', 'default' ) ) || is_admin() ) {
		return;
	}

	require_once get_parent_theme_file_path( '/inc/color-patterns.php' );

	$primary_color = 199;
	if ( 'default' !== get_theme_mod( 'primary_color', 'default' ) ) {
		$primary_color = get_theme_mod( 'primary_color_hue', 199 );
	}
	?>

	<style type="text/css" id="custom-theme-colors" <?php echo is_customize_preview() ? 'data-hue="' . absint( $primary_color ) . '"' : ''; ?>>
		<?php echo twentynineteen_custom_colors_css(); ?>
	</style>
	<?php
}
add_action( 'wp_head', 'twentynineteen_colors_css_wrap' );

/**
 * SVG Icons class.
 */
require get_template_directory() . '/classes/class-twentynineteen-svg-icons.php';

/**
 * Custom Comment Walker template.
 */
require get_template_directory() . '/classes/class-twentynineteen-walker-comment.php';

/**
 * Enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * SVG Icons related functions.
 */
require get_template_directory() . '/inc/icon-functions.php';

/**
 * Custom template tags for the theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

function csv_pull_wpse_212972() {
  global $wpdb;
  $file = 'subscribe_csv';
  $results = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}inx_subscription;",ARRAY_A);

  if (empty($results)) {
    return;
  }

	foreach ($results as $key => $value) {
		if ($value['type']==0) {
				$type='No';
		}else{
			$type='Yes';
		}
	 	$results[$key]['type']=$type;
	}
	 
	 $csv_output=array();
	 $csv_output[] = 'ID';
	 $csv_output[] = 'Email';
	 $csv_output[] = 'Subscribed';
	 $csv_output[] = 'Date';

	 $csv_output = '"'.implode('";"',$csv_output).'";'."\n";

  foreach ($results as $row) {
    $csv_output .= '"'.implode('";"',$row).'";'."\n";
  }
  $csv_output .= "\n";

  $filename = $file."_".date("Y-m-d_H-i",time());
  header("Content-type: application/vnd.ms-excel");
  header("Content-disposition: csv" . date("Y-m-d") . ".csv");
  header( "Content-disposition: filename=".$filename.".csv");
  print $csv_output;
  exit;
}
add_action('wp_ajax_csv_pull','csv_pull_wpse_212972');

// Function to change email address
 
// function wpb_sender_email( $original_email_address ) {
//     return 'contact@inheritx.com';
// }
 
// Function to change sender name
function wpb_sender_name( $original_email_from ) {
    return 'Inheritx';
}
 
// Hooking up our functions to WordPress filters 
//add_filter( 'wp_mail_from', 'wpb_sender_email' );
add_filter( 'wp_mail_from_name', 'wpb_sender_name' );


add_action( 'after_setup_theme', 'wpdocs_theme_setup' );
function wpdocs_theme_setup() {
    add_image_size( 'blog-thumb', 471, 235, true ); // (cropped)
	add_image_size( 'blog-thumb-big', 696, 657, true ); // (cropped)
	add_image_size( 'blog-thumb-small', 110, 110, true ); // (cropped)
	add_image_size( 'blog-thumb-popular', 445, 305, true ); // (cropped)
}
add_filter('acf/settings/remove_wp_meta_box', '__return_false');

// Register portfolio Custom Post Type
function our_portfolio() {

	$labels = array(
		'name'                  => _x( 'Portfolios', 'Post Type General Name', 'text_domain' ),
		'singular_name'         => _x( 'Portfolio', 'Post Type Singular Name', 'text_domain' ),
		'menu_name'             => __( 'Portfolio', 'text_domain' ),
		'name_admin_bar'        => __( 'Portfolio', 'text_domain' ),
		'archives'              => __( 'Item Archives', 'text_domain' ),
		'attributes'            => __( 'Item Attributes', 'text_domain' ),
		'parent_item_colon'     => __( 'Parent Portfolio:', 'text_domain' ),
		'all_items'             => __( 'All Portfolio', 'text_domain' ),
		'add_new_item'          => __( 'Add New Portfolio', 'text_domain' ),
		'add_new'               => __( 'Add New Portfolio', 'text_domain' ),
		'new_item'              => __( 'New Portfolio', 'text_domain' ),
		'edit_item'             => __( 'Edit Portfolio', 'text_domain' ),
		'update_item'           => __( 'Update Portfolio', 'text_domain' ),
		'view_item'             => __( 'View Portfolio', 'text_domain' ),
		'view_items'            => __( 'View Portfolio', 'text_domain' ),
		'search_items'          => __( 'Search Portfolio', 'text_domain' ),
		'not_found'             => __( 'Not found', 'text_domain' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'text_domain' ),
		'featured_image'        => __( 'Featured Image', 'text_domain' ),
		'set_featured_image'    => __( 'Set featured image', 'text_domain' ),
		'remove_featured_image' => __( 'Remove featured image', 'text_domain' ),
		'use_featured_image'    => __( 'Use as featured image', 'text_domain' ),
		'insert_into_item'      => __( 'Insert into item', 'text_domain' ),
		'uploaded_to_this_item' => __( 'Uploaded to this item', 'text_domain' ),
		'items_list'            => __( 'Items list', 'text_domain' ),
		'items_list_navigation' => __( 'Items list navigation', 'text_domain' ),
		'filter_items_list'     => __( 'Filter items list', 'text_domain' ),
	);
	$args = array(
		'label'                 => __( 'Portfolio', 'text_domain' ),
		'description'           => __( 'Add portfolio', 'text_domain' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'thumbnail', 'comments', 'trackbacks', 'revisions', 'custom-fields', 'page-attributes', 'post-formats' ),
		'taxonomies'            => array('post_tag' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'page',
	);
	register_post_type( 'portfolio_type', $args );

}
add_action( 'init', 'our_portfolio', 0 );

// Register partner Custom Post Type
function our_partner() {

	$labels = array(
		'name'                  => _x( 'Partners', 'Post Type General Name', 'text_domain' ),
		'singular_name'         => _x( 'Partner', 'Post Type Singular Name', 'text_domain' ),
		'menu_name'             => __( 'Partner', 'text_domain' ),
		'name_admin_bar'        => __( 'Partner', 'text_domain' ),
		'archives'              => __( 'Item Archives', 'text_domain' ),
		'attributes'            => __( 'Item Attributes', 'text_domain' ),
		'parent_item_colon'     => __( 'Parent Partner:', 'text_domain' ),
		'all_items'             => __( 'All Partner', 'text_domain' ),
		'add_new_item'          => __( 'Add New Partner', 'text_domain' ),
		'add_new'               => __( 'Add New Partner', 'text_domain' ),
		'new_item'              => __( 'New Partner', 'text_domain' ),
		'edit_item'             => __( 'Edit Partner', 'text_domain' ),
		'update_item'           => __( 'Update Partner', 'text_domain' ),
		'view_item'             => __( 'View Partner', 'text_domain' ),
		'view_items'            => __( 'View Partner', 'text_domain' ),
		'search_items'          => __( 'Search Partner', 'text_domain' ),
		'not_found'             => __( 'Not found', 'text_domain' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'text_domain' ),
		'featured_image'        => __( 'Featured Image', 'text_domain' ),
		'set_featured_image'    => __( 'Set featured image', 'text_domain' ),
		'remove_featured_image' => __( 'Remove featured image', 'text_domain' ),
		'use_featured_image'    => __( 'Use as featured image', 'text_domain' ),
		'insert_into_item'      => __( 'Insert into item', 'text_domain' ),
		'uploaded_to_this_item' => __( 'Uploaded to this item', 'text_domain' ),
		'items_list'            => __( 'Items list', 'text_domain' ),
		'items_list_navigation' => __( 'Items list navigation', 'text_domain' ),
		'filter_items_list'     => __( 'Filter items list', 'text_domain' ),
	);
	$args = array(
		'label'                 => __( 'Partner', 'text_domain' ),
		'description'           => __( 'Add partner', 'text_domain' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'thumbnail', 'comments', 'trackbacks', 'revisions', 'custom-fields', 'page-attributes', 'post-formats' ),
		'taxonomies'            => array( 'category', 'post_tag' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'page',
		
	);
	register_post_type( 'partner_type', $args );

}
add_action( 'init', 'our_partner', 0 );

// Register testimonial Custom Post Type
function our_testimonial() {

	$labels = array(
		'name'                  => _x( 'Testimonials', 'Post Type General Name', 'text_domain' ),
		'singular_name'         => _x( 'Testimonial', 'Post Type Singular Name', 'text_domain' ),
		'menu_name'             => __( 'Testimonial', 'text_domain' ),
		'name_admin_bar'        => __( 'Testimonial', 'text_domain' ),
		'archives'              => __( 'Item Archives', 'text_domain' ),
		'attributes'            => __( 'Item Attributes', 'text_domain' ),
		'parent_item_colon'     => __( 'Parent Testimonial:', 'text_domain' ),
		'all_items'             => __( 'All Testimonial', 'text_domain' ),
		'add_new_item'          => __( 'Add New Testimonial', 'text_domain' ),
		'add_new'               => __( 'Add New Testimonial', 'text_domain' ),
		'new_item'              => __( 'New Testimonial', 'text_domain' ),
		'edit_item'             => __( 'Edit Testimonial', 'text_domain' ),
		'update_item'           => __( 'Update Testimonial', 'text_domain' ),
		'view_item'             => __( 'View Testimonial', 'text_domain' ),
		'view_items'            => __( 'View Testimonial', 'text_domain' ),
		'search_items'          => __( 'Search Testimonial', 'text_domain' ),
		'not_found'             => __( 'Not found', 'text_domain' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'text_domain' ),
		'featured_image'        => __( 'Featured Image', 'text_domain' ),
		'set_featured_image'    => __( 'Set featured image', 'text_domain' ),
		'remove_featured_image' => __( 'Remove featured image', 'text_domain' ),
		'use_featured_image'    => __( 'Use as featured image', 'text_domain' ),
		'insert_into_item'      => __( 'Insert into item', 'text_domain' ),
		'uploaded_to_this_item' => __( 'Uploaded to this item', 'text_domain' ),
		'items_list'            => __( 'Items list', 'text_domain' ),
		'items_list_navigation' => __( 'Items list navigation', 'text_domain' ),
		'filter_items_list'     => __( 'Filter items list', 'text_domain' ),
	);
	$args = array(
		'label'                 => __( 'Testimonial', 'text_domain' ),
		'description'           => __( 'Add Testimonial', 'text_domain' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'thumbnail', 'comments', 'trackbacks', 'revisions', 'custom-fields', 'page-attributes', 'post-formats' ),
		'taxonomies'            => array( 'category', 'post_tag' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'page',
		'show_in_rest'          => false,
	);
	register_post_type( 'testimonial _type', $args );

}
add_action( 'init', 'our_testimonial', 0 );

// Register Team Custom Post Type
function our_team() {

	$labels = array(
		'name'                  => _x( 'Teams', 'Post Type General Name', 'text_domain' ),
		'singular_name'         => _x( 'Team', 'Post Type Singular Name', 'text_domain' ),
		'menu_name'             => __( 'Team', 'text_domain' ),
		'name_admin_bar'        => __( 'Team', 'text_domain' ),
		'archives'              => __( 'Item Archives', 'text_domain' ),
		'attributes'            => __( 'Item Attributes', 'text_domain' ),
		'parent_item_colon'     => __( 'Parent Team :', 'text_domain' ),
		'all_items'             => __( 'All Team', 'text_domain' ),
		'add_new_item'          => __( 'Add New Team', 'text_domain' ),
		'add_new'               => __( 'Add New Team', 'text_domain' ),
		'new_item'              => __( 'New Team', 'text_domain' ),
		'edit_item'             => __( 'Edit Team', 'text_domain' ),
		'update_item'           => __( 'Update Team', 'text_domain' ),
		'view_item'             => __( 'View Team', 'text_domain' ),
		'view_items'            => __( 'View Team', 'text_domain' ),
		'search_items'          => __( 'Search Team', 'text_domain' ),
		'not_found'             => __( 'Not found', 'text_domain' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'text_domain' ),
		'featured_image'        => __( 'Featured Image', 'text_domain' ),
		'set_featured_image'    => __( 'Set featured image', 'text_domain' ),
		'remove_featured_image' => __( 'Remove featured image', 'text_domain' ),
		'use_featured_image'    => __( 'Use as featured image', 'text_domain' ),
		'insert_into_item'      => __( 'Insert into item', 'text_domain' ),
		'uploaded_to_this_item' => __( 'Uploaded to this item', 'text_domain' ),
		'items_list'            => __( 'Items list', 'text_domain' ),
		'items_list_navigation' => __( 'Items list navigation', 'text_domain' ),
		'filter_items_list'     => __( 'Filter items list', 'text_domain' ),
	);
	$args = array(
		'label'                 => __( 'Team', 'text_domain' ),
		'description'           => __( 'Add Team', 'text_domain' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'thumbnail', 'revisions', 'custom-fields', 'page-attributes', 'post-formats' ),
		'taxonomies'            => array( 'category', 'post_tag' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'page',
		'show_in_rest'          => false,
	);
	register_post_type( 'team _type', $args );

}
add_action( 'init', 'our_team', 0 );


// Register Client Custom Post Type
function our_client() {

	$labels = array(
		'name'                  => _x( 'Clients', 'Post Type General Name', 'text_domain' ),
		'singular_name'         => _x( 'Client', 'Post Type Singular Name', 'text_domain' ),
		'menu_name'             => __( 'Client', 'text_domain' ),
		'name_admin_bar'        => __( 'Client', 'text_domain' ),
		'archives'              => __( 'Item Archives', 'text_domain' ),
		'attributes'            => __( 'Item Attributes', 'text_domain' ),
		'parent_item_colon'     => __( 'Parent Client:', 'text_domain' ),
		'all_items'             => __( 'All Client', 'text_domain' ),
		'add_new_item'          => __( 'Add New Client', 'text_domain' ),
		'add_new'               => __( 'Add New Client', 'text_domain' ),
		'new_item'              => __( 'New Client', 'text_domain' ),
		'edit_item'             => __( 'Edit Client', 'text_domain' ),
		'update_item'           => __( 'Update Client', 'text_domain' ),
		'view_item'             => __( 'View Client', 'text_domain' ),
		'view_items'            => __( 'View Client', 'text_domain' ),
		'search_items'          => __( 'Search Client', 'text_domain' ),
		'not_found'             => __( 'Not found', 'text_domain' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'text_domain' ),
		'featured_image'        => __( 'Featured Image', 'text_domain' ),
		'set_featured_image'    => __( 'Set featured image', 'text_domain' ),
		'remove_featured_image' => __( 'Remove featured image', 'text_domain' ),
		'use_featured_image'    => __( 'Use as featured image', 'text_domain' ),
		'insert_into_item'      => __( 'Insert into item', 'text_domain' ),
		'uploaded_to_this_item' => __( 'Uploaded to this item', 'text_domain' ),
		'items_list'            => __( 'Items list', 'text_domain' ),
		'items_list_navigation' => __( 'Items list navigation', 'text_domain' ),
		'filter_items_list'     => __( 'Filter items list', 'text_domain' ),
	);
	$args = array(
		'label'                 => __( 'Client', 'text_domain' ),
		'description'           => __( 'Add Client', 'text_domain' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'thumbnail', 'revisions', 'page-attributes', 'post-formats' ),
		'taxonomies'            => array( 'category', 'post_tag' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'page',
		'show_in_rest'          => false,
	);
	register_post_type( 'client _type', $args );

}
add_action( 'init', 'our_client', 0 );

// Register youtube testimonials Custom Post Type
function youtube_testimonials() {

	$labels = array(
		'name'                  => _x( 'YouTube Testimonials', 'Post Type General Name', 'text_domain' ),
		'singular_name'         => _x( 'YouTube Testimonials', 'Post Type Singular Name', 'text_domain' ),
		'menu_name'             => __( 'YouTube Testimonials', 'text_domain' ),
		'name_admin_bar'        => __( 'YouTube Testimonials', 'text_domain' ),
		'archives'              => __( 'Item Archives', 'text_domain' ),
		'attributes'            => __( 'Item Attributes', 'text_domain' ),
		'parent_item_colon'     => __( 'Parent Item:', 'text_domain' ),
		'all_items'             => __( 'All Items', 'text_domain' ),
		'add_new_item'          => __( 'Add New Item', 'text_domain' ),
		'add_new'               => __( 'Add New', 'text_domain' ),
		'new_item'              => __( 'New Item', 'text_domain' ),
		'edit_item'             => __( 'Edit Item', 'text_domain' ),
		'update_item'           => __( 'Update Item', 'text_domain' ),
		'view_item'             => __( 'View Item', 'text_domain' ),
		'view_items'            => __( 'View Items', 'text_domain' ),
		'search_items'          => __( 'Search Item', 'text_domain' ),
		'not_found'             => __( 'Not found', 'text_domain' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'text_domain' ),
		'featured_image'        => __( 'Featured Image', 'text_domain' ),
		'set_featured_image'    => __( 'Set featured image', 'text_domain' ),
		'remove_featured_image' => __( 'Remove featured image', 'text_domain' ),
		'use_featured_image'    => __( 'Use as featured image', 'text_domain' ),
		'insert_into_item'      => __( 'Insert into item', 'text_domain' ),
		'uploaded_to_this_item' => __( 'Uploaded to this item', 'text_domain' ),
		'items_list'            => __( 'Items list', 'text_domain' ),
		'items_list_navigation' => __( 'Items list navigation', 'text_domain' ),
		'filter_items_list'     => __( 'Filter items list', 'text_domain' ),
	);
	$args = array(
		'label'                 => __( 'YouTube Testimonials', 'text_domain' ),
		'description'           => __( 'YouTube Testimonials', 'text_domain' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'thumbnail', 'comments', 'trackbacks', 'revisions', 'custom-fields', 'page-attributes', 'post-formats' ),
		'taxonomies'            => array( 'category', 'post_tag' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'page',
	);
	register_post_type( 'youtube_testimo_type', $args );

}
add_action( 'init', 'youtube_testimonials', 0 );


// Register location Post Type
function location_post_type() {

	$labels = array(
		'name'                  => _x( 'Locations', 'Post Type General Name', 'text_domain' ),
		'singular_name'         => _x( 'Location', 'Post Type Singular Name', 'text_domain' ),
		'menu_name'             => __( 'Location', 'text_domain' ),
		'name_admin_bar'        => __( 'Location', 'text_domain' ),
		'archives'              => __( 'Item Archives', 'text_domain' ),
		'attributes'            => __( 'Item Attributes', 'text_domain' ),
		'parent_item_colon'     => __( 'Parent Item:', 'text_domain' ),
		'all_items'             => __( 'All Locations', 'text_domain' ),
		'add_new_item'          => __( 'Add New Location', 'text_domain' ),
		'add_new'               => __( 'Add New', 'text_domain' ),
		'new_item'              => __( 'New Item', 'text_domain' ),
		'edit_item'             => __( 'Edit Item', 'text_domain' ),
		'update_item'           => __( 'Update Item', 'text_domain' ),
		'view_item'             => __( 'View Item', 'text_domain' ),
		'view_items'            => __( 'View Items', 'text_domain' ),
		'search_items'          => __( 'Search Item', 'text_domain' ),
		'not_found'             => __( 'Not found', 'text_domain' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'text_domain' ),
		'featured_image'        => __( 'Featured Image', 'text_domain' ),
		'set_featured_image'    => __( 'Set featured image', 'text_domain' ),
		'remove_featured_image' => __( 'Remove featured image', 'text_domain' ),
		'use_featured_image'    => __( 'Use as featured image', 'text_domain' ),
		'insert_into_item'      => __( 'Insert into item', 'text_domain' ),
		'uploaded_to_this_item' => __( 'Uploaded to this item', 'text_domain' ),
		'items_list'            => __( 'Items list', 'text_domain' ),
		'items_list_navigation' => __( 'Items list navigation', 'text_domain' ),
		'filter_items_list'     => __( 'Filter items list', 'text_domain' ),
	);
	$args = array(
		'label'                 => __( 'Location', 'text_domain' ),
		'description'           => __( 'Locations', 'text_domain' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'thumbnail', 'comments', 'trackbacks', 'revisions', 'custom-fields', 'page-attributes', 'post-formats' ),
		// 'taxonomies'            => array( 'category', 'post_tag' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'page',
	);
	register_post_type( 'location_type', $args );

}
add_action( 'init', 'location_post_type', 0 );

// Register career Custom Post Type
function career_post_type() {

	$labels = array(
		'name'                  => _x( 'Career', 'Post Type General Name', 'text_domain' ),
		'singular_name'         => _x( 'Career', 'Post Type Singular Name', 'text_domain' ),
		'menu_name'             => __( 'Career', 'text_domain' ),
		'name_admin_bar'        => __( 'Career', 'text_domain' ),
		'archives'              => __( 'Item Archives', 'text_domain' ),
		'attributes'            => __( 'Item Attributes', 'text_domain' ),
		'parent_item_colon'     => __( 'Parent Item:', 'text_domain' ),
		'all_items'             => __( 'All Items', 'text_domain' ),
		'add_new_item'          => __( 'Add New Item', 'text_domain' ),
		'add_new'               => __( 'Add New', 'text_domain' ),
		'new_item'              => __( 'New Item', 'text_domain' ),
		'edit_item'             => __( 'Edit Item', 'text_domain' ),
		'update_item'           => __( 'Update Item', 'text_domain' ),
		'view_item'             => __( 'View Item', 'text_domain' ),
		'view_items'            => __( 'View Items', 'text_domain' ),
		'search_items'          => __( 'Search Item', 'text_domain' ),
		'not_found'             => __( 'Not found', 'text_domain' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'text_domain' ),
		'featured_image'        => __( 'Featured Image', 'text_domain' ),
		'set_featured_image'    => __( 'Set featured image', 'text_domain' ),
		'remove_featured_image' => __( 'Remove featured image', 'text_domain' ),
		'use_featured_image'    => __( 'Use as featured image', 'text_domain' ),
		'insert_into_item'      => __( 'Insert into item', 'text_domain' ),
		'uploaded_to_this_item' => __( 'Uploaded to this item', 'text_domain' ),
		'items_list'            => __( 'Items list', 'text_domain' ),
		'items_list_navigation' => __( 'Items list navigation', 'text_domain' ),
		'filter_items_list'     => __( 'Filter items list', 'text_domain' ),
	);
	$args = array(
		'label'                 => __( 'Career', 'text_domain' ),
		'description'           => __( 'Add career post', 'text_domain' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'thumbnail', 'comments', 'trackbacks', 'revisions', 'custom-fields', 'page-attributes', 'post-formats' ),
		// 'taxonomies'            => array( 'category', 'post_tag' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'page',
	);
	register_post_type( 'career_type', $args );

}
add_action( 'init', 'career_post_type', 0 );

// Register FAQ Custom Post Type
function faq_post_type() {

	$labels = array(
		'name'                  => _x( 'FAQs', 'Post Type General Name', 'text_domain' ),
		'singular_name'         => _x( 'FAQ', 'Post Type Singular Name', 'text_domain' ),
		'menu_name'             => __( 'FAQ', 'text_domain' ),
		'name_admin_bar'        => __( 'FAQ', 'text_domain' ),
		'archives'              => __( 'Item Archives', 'text_domain' ),
		'attributes'            => __( 'Item Attributes', 'text_domain' ),
		'parent_item_colon'     => __( 'Parent Item:', 'text_domain' ),
		'all_items'             => __( 'All Items', 'text_domain' ),
		'add_new_item'          => __( 'Add New Item', 'text_domain' ),
		'add_new'               => __( 'Add New', 'text_domain' ),
		'new_item'              => __( 'New Item', 'text_domain' ),
		'edit_item'             => __( 'Edit Item', 'text_domain' ),
		'update_item'           => __( 'Update Item', 'text_domain' ),
		'view_item'             => __( 'View Item', 'text_domain' ),
		'view_items'            => __( 'View Items', 'text_domain' ),
		'search_items'          => __( 'Search Item', 'text_domain' ),
		'not_found'             => __( 'Not found', 'text_domain' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'text_domain' ),
		'featured_image'        => __( 'Featured Image', 'text_domain' ),
		'set_featured_image'    => __( 'Set featured image', 'text_domain' ),
		'remove_featured_image' => __( 'Remove featured image', 'text_domain' ),
		'use_featured_image'    => __( 'Use as featured image', 'text_domain' ),
		'insert_into_item'      => __( 'Insert into item', 'text_domain' ),
		'uploaded_to_this_item' => __( 'Uploaded to this item', 'text_domain' ),
		'items_list'            => __( 'Items list', 'text_domain' ),
		'items_list_navigation' => __( 'Items list navigation', 'text_domain' ),
		'filter_items_list'     => __( 'Filter items list', 'text_domain' ),
	);
	$args = array(
		'label'                 => __( 'FAQ', 'text_domain' ),
		'description'           => __( 'Add FAQ', 'text_domain' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'thumbnail', 'comments', 'trackbacks', 'revisions', 'custom-fields', 'page-attributes', 'post-formats' ),
		'taxonomies'            => array( 'category', 'post_tag' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'page',
	);
	register_post_type( 'faq_type', $args );

}
add_action( 'init', 'faq_post_type', 0 );

// Register gallery Custom Post Type
function gallery_post_type() {

	$labels = array(
		'name'                  => _x( 'Gallery', 'Post Type General Name', 'text_domain' ),
		'singular_name'         => _x( 'Gallery', 'Post Type Singular Name', 'text_domain' ),
		'menu_name'             => __( 'Gallery', 'text_domain' ),
		'name_admin_bar'        => __( 'GalleryType', 'text_domain' ),
		'archives'              => __( 'Item Archives', 'text_domain' ),
		'attributes'            => __( 'Item Attributes', 'text_domain' ),
		'parent_item_colon'     => __( 'Parent Item:', 'text_domain' ),
		'all_items'             => __( 'All Gallery', 'text_domain' ),
		'add_new_item'          => __( 'Add New Image', 'text_domain' ),
		'add_new'               => __( 'Add New image', 'text_domain' ),
		'new_item'              => __( 'New Item', 'text_domain' ),
		'edit_item'             => __( 'Edit Item', 'text_domain' ),
		'update_item'           => __( 'Update Item', 'text_domain' ),
		'view_item'             => __( 'View Item', 'text_domain' ),
		'view_items'            => __( 'View Items', 'text_domain' ),
		'search_items'          => __( 'Search Item', 'text_domain' ),
		'not_found'             => __( 'Not found', 'text_domain' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'text_domain' ),
		'featured_image'        => __( 'Featured Image', 'text_domain' ),
		'set_featured_image'    => __( 'Set featured image', 'text_domain' ),
		'remove_featured_image' => __( 'Remove featured image', 'text_domain' ),
		'use_featured_image'    => __( 'Use as featured image', 'text_domain' ),
		'insert_into_item'      => __( 'Insert into item', 'text_domain' ),
		'uploaded_to_this_item' => __( 'Uploaded to this item', 'text_domain' ),
		'items_list'            => __( 'Items list', 'text_domain' ),
		'items_list_navigation' => __( 'Items list navigation', 'text_domain' ),
		'filter_items_list'     => __( 'Filter items list', 'text_domain' ),
	);
	$args = array(
		'label'                 => __( 'Gallery', 'text_domain' ),
		'description'           => __( 'Gallery Description', 'text_domain' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'thumbnail', 'comments', 'trackbacks', 'revisions', 'custom-fields', 'page-attributes', 'post-formats' ),
		// 'taxonomies'            => array( 'category', 'post_tag' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'page',
	);
	register_post_type( 'gallery_type', $args );

}
add_action( 'init', 'gallery_post_type', 0 );

// Let us create Taxonomy for Custom Post Type
add_action( 'init', 'crunchify_create_deals_custom_taxonomy', 0 );
 
//create a custom taxonomy name it "type" for your posts
function crunchify_create_deals_custom_taxonomy() {
 
  $labels = array(
    'name' => _x( 'Category', 'taxonomy general name' ),
    'singular_name' => _x( 'Type', 'taxonomy singular name' ),
    'search_items' =>  __( 'Search Category' ),
    'all_items' => __( 'All Category' ),
    'parent_item' => __( 'Parent Category' ),
    'parent_item_colon' => __( 'Parent Category:' ),
    'edit_item' => __( 'Edit Category' ), 
    'update_item' => __( 'Update Category' ),
    'add_new_item' => __( 'Add New Category' ),
    'new_item_name' => __( 'New Type Name' ),
    'menu_name' => __( 'Category' ),
  ); 	
 
  register_taxonomy('types',array('portfolio_type'), array(
    'hierarchical' => true,
    'labels' => $labels,
    'show_ui' => true,
    'show_admin_column' => true,
    'query_var' => true,
    'rewrite' => array( 'slug' => 'type' ),
  ));
}

// Let us create Taxonomy for Custom Post Type
//add_action( 'init', 'crunchify_create_faq_custom_taxonomy', 0 );

//create a custom taxonomy name it "type" for your posts
// function crunchify_create_faq_custom_taxonomy() {
 
//   $labels = array(
//     'name' => _x( 'Types', 'taxonomy general name' ),
//     'singular_name' => _x( 'Category', 'taxonomy singular name' ),
//     'search_items' =>  __( 'Search Category' ),
//     'all_items' => __( 'All Category' ),
//     'parent_item' => __( 'Parent Category' ),
//     'parent_item_colon' => __( 'Parent Category:' ),
//     'edit_item' => __( 'Edit Category' ), 
//     'update_item' => __( 'Update Category' ),
//     'add_new_item' => __( 'Add New Category' ),
//     'new_item_name' => __( 'New Category Name' ),
//     'menu_name' => __( 'Category' ),
//   ); 	
 
//   register_taxonomy('types',array('faq_type'), array(
//     'hierarchical' => true,
//     'labels' => $labels,
//     'show_ui' => true,
//     'show_admin_column' => true,
//     'query_var' => true,
//     'rewrite' => array( 'slug' => 'faq_cat' ),
//   ));
// }

function get_cat_data($postID){
	$catArray=get_the_category( $postID );
	$blogCatArray=array();
	foreach($catArray as $cat){
	$blogCatArray[]=array(
		'name'=>$cat->cat_name,
		'slug'=>$cat->slug,
	);
	}
	return $blogCatArray;
}

function my_home_page_content() {

global $post;
//Portfolio section start
$proInfoArray= array();
$args = array( 'post_type' => 'portfolio_type', 'post_status' => 'publish', 'order' => 'DESC', 'posts_per_page' => 8,
'tax_query' => array(
            array(
                'taxonomy' => 'types',
                'field' => 'slug',
                'terms' => 'home',
            ),
        ),
 );
$the_query = new WP_Query( $args ); 

 if ( $the_query->have_posts() ) : 
	 while ( $the_query->have_posts() ) : $the_query->the_post(); 
		 $title=get_the_title();
		 $title = html_entity_decode($title , ENT_COMPAT, 'UTF-8');
		 $post_id=$post->ID;
		 $img_url=get_the_post_thumbnail_url($post->ID, 'full');
		 $industry=get_field('industry',$post->ID);
		 $portfolioInfo = array(
		    'id'=>$post_id,
		    'title'=>$title,
		    'industry'=>$industry,
		    'feature_image'=>$img_url
		    );
		 $proInfoArray[]=$portfolioInfo;
	endwhile;
	wp_reset_postdata();
endif;

//Portfolio section End

// $partnerInfoArray= array();
// $partnerargs = array( 'post_type' => 'partner_type', 'order' => 'ASC', 'posts_per_page' => -1 );
// $partner_query = new WP_Query( $partnerargs ); 

//  if ( $partner_query->have_posts() ) : 
//  while ( $partner_query->have_posts() ) : $partner_query->the_post(); 
//  $partnerTitle=get_the_title();
//  $partner_post_id=$post->ID;
//  $partner_img_url=get_the_post_thumbnail_url($post->ID, 'full');
//  $partnerInfo = array(
//     'id'=>$partner_post_id,
//     'title'=>$partnerTitle,
//     'feature_image'=>$partner_img_url
//     );
// $partnerInfoArray[]=$partnerInfo;
// endwhile;
// wp_reset_postdata();
// endif;

//Testmonial section start

$testimonialInfoArray= array();
$testimonialargs = array( 'post_type' => 'testimonial_type', 'post_status' => 'publish', 'order' => 'DESC', 'posts_per_page' => -1 );
$testimonial_query = new WP_Query( $testimonialargs );
 if ( $testimonial_query->have_posts() ) : 
 while ( $testimonial_query->have_posts() ) : $testimonial_query->the_post(); 
 $testimonialTitle=get_the_title();
 $testimonial_post_id=$post->ID;
 $testimonial_img_url=get_the_post_thumbnail_url($post->ID, 'full');
 //$designation=get_post_meta($post->ID, 'designation', true);
 $designation=get_field('designation');
 
 $testimonialContent=substr(get_the_content(), 0, 200);
 $testimonialInfo = array(
    'id'=>$testimonial_post_id,
    'title'=>$testimonialTitle,
    'content'=>$testimonialContent,
    'feature_image'=>$testimonial_img_url,
    'designation'=>$designation
    );
$testimonialInfoArray[]=$testimonialInfo;
endwhile;
wp_reset_postdata();
endif;

//youTube Testmonial section start

$youTubeInfoArray= array();
$youTubeargs = array( 'post_type' => 'youtube_testimo_type', 'post_status' => 'publish', 'order' => 'DESC', 'posts_per_page' => -1);
$youTube_query = new WP_Query( $youTubeargs );
 if ( $youTube_query->have_posts() ) : 
 while ( $youTube_query->have_posts() ) : $youTube_query->the_post(); 
 $youTubeTitle=get_the_title();
 $youTube_post_id=$post->ID;
 //$youTube_img_url=get_the_post_thumbnail_url($post->ID, 'full');
 $youTubedesignation=get_post_meta($post->ID, 'designation', true);
 $youTubeUrl=get_post_meta($post->ID, 'youtube_url', true);
 $video_id = explode("?v=", $youTubeUrl);
 $video_id = $video_id[1];
 $youTube_img_url="https://img.youtube.com/vi/".$video_id."/hqdefault.jpg";
  $youTubeInfo = array(
    'id'=>$youTube_post_id,
    'title'=>$youTubeTitle,
    'feature_image'=>$youTube_img_url,
    'youtube_url'=>$youTubeUrl,
    'designation'=>$youTubedesignation,
    'video_id'=>$video_id
    );
$youTubeInfoArray[]=$youTubeInfo;
endwhile;
wp_reset_postdata();
endif;

//youTube Testmonial section end

//our team section start
$teamInfoArray= array();
$teamargs = array( 'post_type' => 'team_type', 'post_status' => 'publish', 'order' => 'ASC', 'posts_per_page' => 4);
$team_query = new WP_Query( $teamargs );
 if ( $team_query->have_posts() ) : 
 while ( $team_query->have_posts() ) : $team_query->the_post(); 
 $teamTitle=get_the_title();
 $team_post_id=$post->ID;
 $team_img_url=get_the_post_thumbnail_url($post->ID, 'full');
 //$teamDesignation=get_post_meta($post->ID, 'designation', true);
 $teamDesignation=get_field('designation');
 
 $teamInfo = array(
    'id'=>$team_post_id,
    'title'=>$teamTitle,
    'feature_image'=>$team_img_url,
    'designation'=>$teamDesignation
    );
$teamInfoArray[]=$teamInfo;
endwhile;
wp_reset_postdata();
endif;
//our Team section end

//our Client section start
$clientInfoArray= array();
$clientargs = array( 'post_type' => 'client_type', 'post_status' => 'publish', 'order' => 'DESC', 'posts_per_page' => -1);
$client_query = new WP_Query( $clientargs );
 if ( $client_query->have_posts() ) : 
 while ( $client_query->have_posts() ) : $client_query->the_post(); 
 $clientTitle=get_the_title();
 $client_post_id=$post->ID;
 $client_img_url=get_the_post_thumbnail_url($post->ID, 'full');
 $clientInfo = array(
    'id'=>$client_post_id,
    'title'=>$clientTitle,
    'feature_image'=>$client_img_url
    );
$clientInfoArray[]=$clientInfo;
endwhile;
wp_reset_postdata();
endif;
//our Client section end

//our blog section start
$blogInfoArray= array();
$blogargs = array( 'post_type' => 'post', 'post_status' => 'publish', 'order' => 'DESC', 'posts_per_page' => 2);
$blog_query = new WP_Query( $blogargs );
 if ( $blog_query->have_posts() ) : 
 while ( $blog_query->have_posts() ) : $blog_query->the_post(); 
 $blogTitle=get_the_title();
 $blog_post_id=$post->ID;
 $blog_img_url=get_the_post_thumbnail_url($post->ID, 'blog-thumb');
 $custom_author=get_field('author_name',$post->ID);
 $slug = $post->post_name;
 if ($custom_author) {
 	$author=$custom_author;
 }else{
 	$author=get_the_author();
 } 
 $post_date=get_the_date();
 $blogInfo = array(
    'id'=>$blog_post_id,
    'title'=>$blogTitle,
    'author'=>$author,
     'slug'=>$slug,
    'post_date'=>$post_date,
    'feature_image'=>$blog_img_url
    );
$blogInfoArray[]=$blogInfo;
endwhile;
wp_reset_postdata();
endif;
//our blog section end

	$msg="Get home page content";
    $param = array('status'=>1,'message'=>$msg,'portfolio'=>$proInfoArray,'testimonial'=>$testimonialInfoArray,'youtube_testimonial'=>$youTubeInfoArray,'teams'=>$teamInfoArray,'clients'=>$clientInfoArray,'blogs'=>$blogInfoArray);
	echo json_encode($param);
	exit();
}

function get_locations(){
	global $post;
	//our locaton section start
	$locatonInfoArray= array();
	$locatonargs = array( 'post_type' => 'location_type', 'post_status' => 'publish', 'order' => 'DESC', 'posts_per_page' => 4);
	$locaton_query = new WP_Query( $locatonargs );
	 if ( $locaton_query->have_posts() ) : 
	 while ( $locaton_query->have_posts() ) : $locaton_query->the_post(); 
	 $locatonTitle=get_the_title();
	 $locaton_post_id=$post->ID;
	 // $locaton_add1=get_post_meta($post->ID, 'address1', true);
	 // $locaton_add2=get_post_meta($post->ID, 'address2', true);
	 // $locaton_country=get_post_meta($post->ID, 'country', true);
	 $locaton_add1=get_field('address1');
	 $locaton_add2=get_field('address2');
	 $locaton_country=get_field('country');
	 $locaton_img_url=get_the_post_thumbnail_url($post->ID, 'full');
	 $locatonInfo = array(
	    'id'=>$locaton_post_id,
	    'title'=>$locatonTitle,
	    'address1'=>$locaton_add1,
	    'address2'=>$locaton_add2,
	    'country'=>$locaton_country,
	    'location_image'=>$locaton_img_url
	    );
	$locatonInfoArray[]=$locatonInfo;
	endwhile;
	wp_reset_postdata();
	endif;
	$contactInfo = array(
	    'phone'=>get_option('inx_phone_num'),
	    'alt_phone'=>get_option('inx_alt_phone_num'),
	    'contact_email'=>get_option('inx_contact_email'),
	    'hr_email'=>get_option('inx_hr_email')
    );
//our locaton section end
	$msg="Get location content";
    $param = array('status'=>1,'message'=>$msg,'locations'=>$locatonInfoArray, 'contactinfo'=>$contactInfo);
	echo json_encode($param);
	exit();
}

function get_portfolio($data){
	$cat_slug_port=$data['category_slug'];
	global $post;
	if ($data['id']) {
		$post_per_page=$data['id'];
	}else{
		$post_per_page=-1;
	}
	$terms = get_terms( array(
	    'taxonomy' => 'types',
	    'hide_empty' => false,
	) );
	if (!$cat_slug_port) {
	$portfolioPostItemArray= array();
	$portfolioItemArray= array();
	foreach ($terms as $key => $term) {
		if ($term->term_id!=255) {
		$term_id=$term->term_id;
		$term_name=$term->name;
		$term_slug=$term->slug;
		$portfolioItem = array(
		    'cat_id'=>$term_id,
		    'name'=>$term_name,
		    'slug'=>$term_slug
			);
		$portfolioItemArray[]=$portfolioItem;
  		//$portfolioPostItemArray[]=$term_slug;
			}
		}
	}
	if ($cat_slug_port) {
	   $args = array(
	            'post_type' => 'portfolio_type',
	            'orderby' =>'menu_order',
				'order' => 'DESC',
				'post_status' => 'publish',
				'posts_per_page' => $post_per_page,
	            'tax_query' => array(               
	                array(
	                    'taxonomy' => 'types',
	                    'field' => 'slug',
	                    'terms' => $cat_slug_port,
	                ),
	            ),
	        ); 

	    }else{
		$args = array(
				'post_type' =>'portfolio_type',
				 'orderby' =>'menu_order',
				'order' => 'DESC',
				'post_status' => 'publish',
				'posts_per_page' => $post_per_page
			);

		}
	 
		//$gallery_image_url=array();
		$item_query = new WP_Query( $args );
		if ( $item_query->have_posts() ) : 
		while ( $item_query->have_posts() ) : $item_query->the_post(); 
			$current_cats='';
			$gallery_image_url=array();
			$cat_slug=array();
			$itemTitle=get_the_title();
			$itemTitle = html_entity_decode($itemTitle , ENT_COMPAT, 'UTF-8');
		 	$item_post_id=$post->ID;
		 	$item_content=get_the_content();
		 	$industry=get_field('industry',$item_post_id);
		 	$country=get_field('country',$item_post_id);
		 	$technology=get_field('technology',$item_post_id);
	 		$item_img_url=get_the_post_thumbnail_url($post->ID, 'full');
	 		$current_cats=get_the_terms($item_post_id,'types');
	 		foreach ($current_cats as $key => $current_cat) {
			if ($current_cat->term_id!=255) {
				$cat_slug[]=$current_cat->slug;
				}
			}
	 		//print_r($current_cat);
	 		if(get_field('gallery_images',$item_post_id)):
		    	 while(has_sub_field('gallery_images',$item_post_id)):
		    	 	$gallery_image_url[] = get_sub_field('images',$item_post_id);
		    	 endwhile;
		    endif;
		 	$itemInfo = array(
			    'post_id'=>$item_post_id,
			    'title'=>$itemTitle,
			    'content'=>$item_content,
			    'feature_image'=>$item_img_url,
			    'gallery_image'=>$gallery_image_url,
			    'category_slug'=>$cat_slug,
			    'industry'=>$industry,
			    'country'=>$country,
			    'technology'=>$technology
		    );
			$portfolioPostItemArray[]=$itemInfo;
		endwhile;
		wp_reset_postdata();
		endif;

	$msg="Get portfolio content";
    if ($cat_slug_port) {
		$param = array('status'=>1,'message'=>$msg,'portfolio_item'=>$portfolioPostItemArray);
	}else{
    $param = array('status'=>1,'message'=>$msg,'category'=>$portfolioItemArray,'portfolio_item'=>$portfolioPostItemArray);
    }
	echo json_encode($param);
	exit();
}

function send_form_deta()
{
	
	global $wpdb;
	//Get data from POST
	$name=trim($_POST['name']);
	$email=trim($_POST['email']);
	$country=trim($_POST['country']);
	$phone=trim($_POST['phone']);
	$project_type=trim($_POST['project_type']);
	$project_budget=trim($_POST['project_budget']);
	$project_details=trim($_POST['project_details']);
	$project_nda=trim($_POST['project_nda']);
	$subject='Project Request from '.$name;

	if (!$name) {
		$msg = "Please enter name";
	    $param = array('status'=>0,'message'=>$msg);  
	}elseif (!$email) {
		$msg = "Please enter email";
	    $param = array('status'=>0,'message'=>$msg); 
	}elseif(!filter_var($email, FILTER_VALIDATE_EMAIL)){
		$msg = "Please enter valid email id";
	    $param = array('status'=>0,'message'=>$msg); 
	}elseif (!$country) {
		$msg = "Please enter country";
	    $param = array('status'=>0,'message'=>$msg); 
	}elseif (!$phone) {
		$msg = "Please enter phone";
	    $param = array('status'=>0,'message'=>$msg); 
	}elseif (!$project_budget) {
		$msg = "Please enter project budget";
	    $param = array('status'=>0,'message'=>$msg); 
	}else{
	// Sent email to register user                               
	$email_subject = $subject;
	$messages="<table cellspacing='0' cellpadding='0' width='100%' border='0'>
	      <tr style='background-color:#24620C;color:#fff;font-family: sans-serif;font-size: 82%;'>
	        <td align='center' colspan='4'>
	          <h3 style='margin-top:10px;'>New enquiry details<h3>
	        </td>
	      </tr/>
	      <tr><td colspan='4'>&nbsp;</td></tr>
	      <tr><td colspan='4'>&nbsp;</td></tr>
	      <tr>
	        <td width='5%'></td>
	        <td width='25%'><b>Name</b></td>
	        <td width='5%'><b>:</b></td>
	        <td>".$name."</td>
	      </tr>
	      <tr><td colspan='4'>&nbsp;</td></tr>
	      <tr>
	        <td width='5%'></td>
	        <td width='25%'><b>Email</b></td>
	        <td width='5%'><b>:</b></td>
	        <td>".$email."</td>
	      </tr>
	       <tr><td colspan='4'>&nbsp;</td></tr>
	      <tr>
	        <td width='5%'></td>
	        <td width='25%'><b>Phone</b></td>
	        <td width='5%'><b>:</b></td>
	        <td>".$phone."</td>
	      </tr>
	      <tr><td colspan='4'>&nbsp;</td></tr>
	      <tr>
	        <td width='5%'></td>
	        <td width='25%'><b>Country</b></td>
	        <td width='5%'><b>:</b></td>
	        <td>".$country."</td>
	      </tr>
	      <tr><td colspan='4'>&nbsp;</td></tr>
	      <tr>
	        <td width='5%'></td>
	        <td width='25%'><b>Project Type</b></td>
	        <td width='5%'><b>:</b></td>
	        <td>".$project_type."</td>
	      </tr>
	      <tr><td colspan='4'>&nbsp;</td></tr>
	      <tr>
	        <td width='5%'></td>
	        <td width='25%'><b>Project Budget</b></td>
	        <td width='5%'><b>:</b></td>
	        <td>".$project_budget."</td>
	      </tr>
	      <tr><td colspan='4'>&nbsp;</td></tr>
	      <tr>
	        <td>&nbsp;</td>
	        <td><b>Project Details</b></td>
	        <td><b>:</b></td>
	        <td>".$project_details."</td>
	      </tr>
	      <tr><td colspan='4'>&nbsp;</td></tr>";
	      if ($project_nda==1) {
	      $messages.="<tr>
	        <td>&nbsp;</td>
	        <td><b>Project NDA</b></td>
	        <td><b>:</b></td>
	        <td>Client has requested for Non Disclosure Agreement</td>
	      	</tr>";
	      }

	      $messages.="<tr><td colspan='4'>&nbsp;</td></tr>
	      </table>";
	      $headers = 'MIME-Version: 1.0' . "\r\n";
	      $headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
	      $headers.= 'From: '. $email . "\r\n";
	      //$admin_email = get_option( 'admin_email' );
	      $admin_email = get_option('inx_contact_email');
	      if(wp_mail($admin_email,$subject,$messages,$headers)) {
	                $msg = "Email sent successfully";
	                $param = array('status'=>1,'message'=>$msg);
	               
	            } else {
	                $msg = "Email could not be sent";
	                $param = array('status'=>0,'message'=>$msg);  
	        }

	}

		echo json_encode($param);
		exit();


}

//Carrer form data
function send_careerform_data()
{
	
	global $wpdb;
	//Get data from POST
	$name=trim($_POST['name']);
	$email=trim($_POST['email']);
	$phone=trim($_POST['phone']);
	//$resume=trim($_POST['resume']);
	$resume=trim($_FILES["resume"]["name"]);
	//$ext = strtolower(substr($resume, strpos($resume,'.'), strlen($resume)-1)); //get the extention in lower case
	$ext = substr(strrchr($_FILES['resume']['name'], "."), 1);
	$subject='Job Request from '.$name;
 	$allowed = array('doc', 'docx', 'odf', 'pdf');
	if (!$name) {
		$msg = "Please enter name";
	    $param = array('status'=>0,'message'=>$msg);  
	}elseif (!$email) {
		$msg = "Please enter email";
	    $param = array('status'=>0,'message'=>$msg); 
	}elseif(!filter_var($email, FILTER_VALIDATE_EMAIL)){
		$msg = "Please enter valid email id";
	    $param = array('status'=>0,'message'=>$msg); 
	}elseif (!$phone) {
		$msg = "Please enter phone";
	    $param = array('status'=>0,'message'=>$msg); 
	}elseif (!in_array($ext, $allowed)){
		$msg = "Error!,Allowed file types are doc,docx,pdf,odf";
	    $param = array('status'=>0,'message'=>$msg); 
	}
	else{

	$upload_dir   = wp_upload_dir();
    $upload_url = $upload_dir['url'];
    $upload_path = $upload_dir['path'];
    $date = date('Y-m-d H:i:s');
    $attachment_resume = $upload_url .'/'.$name.'_'.$date.'_'.basename($_FILES["resume"]["name"]);
    $target_file = $upload_path .'/'.$name.'_'.$date.'_'.basename($_FILES["resume"]["name"]);
    move_uploaded_file($_FILES["resume"]["tmp_name"], $target_file);
	$attachment = array($target_file);
	
	// Sent email to register user                               
	$email_subject = $subject;
	$messages="<table cellspacing='0' cellpadding='0' width='100%' border='0'>
	      <tr style='background-color:#24620C;color:#fff;font-family: sans-serif;font-size: 82%;'>
	        <td align='center' colspan='4'>
	          <h3 style='margin-top:10px;'>Job enquiry details<h3>
	        </td>
	      </tr/>
	      <tr><td colspan='4'>&nbsp;</td></tr>
	      <tr><td colspan='4'>&nbsp;</td></tr>
	      <tr>
	        <td width='5%'></td>
	        <td width='25%'><b>Name</b></td>
	        <td width='5%'><b>:</b></td>
	        <td>".$name."</td>
	      </tr>
	      <tr><td colspan='4'>&nbsp;</td></tr>
	      <tr>
	        <td width='5%'></td>
	        <td width='25%'><b>Email</b></td>
	        <td width='5%'><b>:</b></td>
	        <td>".$email."</td>
	      </tr>
	       <tr><td colspan='4'>&nbsp;</td></tr>
	      <tr>
	        <td width='5%'></td>
	        <td width='25%'><b>Phone</b></td>
	        <td width='5%'><b>:</b></td>
	        <td>".$phone."</td>
	      </tr>
	      <tr><td colspan='4'>&nbsp;</td></tr>
	      <tr><td colspan='4'>&nbsp;</td></tr>
	      </table>";
	      $headers = 'MIME-Version: 1.0' . "\r\n";
	      $headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
	      $headers.= 'From: '. $email . "\r\n";
	      //$admin_email = get_option( 'admin_email' );
	      $admin_email=trim(get_option('inx_hr_email'));
	      if(wp_mail($admin_email,$subject,$messages,$headers, $attachment)) {
	                $msg = "Email sent successfully";
	                $param = array('status'=>1,'message'=>$msg);
	               
	            } else {
	                $msg = "Email could not be sent";
	                $param = array('status'=>0,'message'=>$msg);  
	        }

	}

		echo json_encode($param);
		exit();
}


function get_blog_data($data)
{
	global $post;
	$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
	if ($data['id']) {
		$paged=$data['id'];
	}else{
		$paged=1;
	}
	$search=$data['search'];
	$cat_slug=$data['category_slug'];
	if ($cat_slug) {
		$posts_per_page=2;
	}else{
		$posts_per_page=4;
	}
	
	//our blog section start
	$blogInfoArray= array();

	$blogargs = array( 'post_type' => 'post', 'post_status' => 'publish', 'order' => 'DESC', 'posts_per_page' => $posts_per_page, 'paged' => $paged, 's' => $search, 'category_name' => $cat_slug);
	$blog_query = new WP_Query( $blogargs );
	$post_count = $blog_query->found_posts;
	 if ( $blog_query->have_posts() ) { 
	 while ( $blog_query->have_posts() ) : $blog_query->the_post(); 
	 $blogTitle=get_the_title();
	 $blogTitle = html_entity_decode($blogTitle , ENT_COMPAT, 'UTF-8');
	 $blog_post_id=$post->ID;
	 $slug = $post->post_name;
     $custom_author=get_field('author_name',$post->ID);
     if ($custom_author) {
        $author=$custom_author;
     }else{
        $author=get_the_author();
     }
	 $blog_img_url=get_the_post_thumbnail_url($post->ID, 'blog-thumb');
	 $post_date=get_the_date();
	 $blogInfo = array(
	    'id'=>$blog_post_id,
	    'title'=>$blogTitle,
	    'author'=>$author,
	    'post_date'=>$post_date,
	     'slug'=>$slug,
	    'feature_image'=>$blog_img_url
	    );
	$blogInfoArray[]=$blogInfo;
	endwhile;
	$total_pages = $blog_query->max_num_pages;

   if ($total_pages > 1){

    $current_page = $paged;
	$pagination_url=site_url().'wp-json/api/v1/blog';
    $custom_pagination= paginate_links(array(
        'base' => $pagination_url. '%_%',
        'format' => '/%#%',
        'current' => $current_page,
        'total' => $total_pages,
        'mid_size'=> 8,
        'prev_next' => true,
        'prev_text' => __('Previous'),
        'next_text' => __('Next'),
    	));
	}
	wp_reset_postdata();
	$msg="Get blog content";
	}elseif ($post_count==0 && $search) {
		$msg="post not found";
	}
	else{
		$blogargs = array( 'post_type' => 'post', 'post_status' => 'publish', 'order' => 'DESC', 'posts_per_page' => 2);
		$blog_query = new WP_Query( $blogargs );
		$post_count = $blog_query->found_posts;
		if ( $blog_query->have_posts() ) { 
		while ( $blog_query->have_posts() ) : $blog_query->the_post(); 
		$blogTitle=get_the_title();
		$blogTitle = html_entity_decode($blogTitle , ENT_COMPAT, 'UTF-8');
		$blog_post_id=$post->ID;
		 $slug = $post->post_name;
		$custom_author=get_field('author_name',$post->ID);
		 if ($custom_author) {
		 	$author=$custom_author;
		 }else{
		 	$author=get_the_author();
		 } 
		$blog_img_url=get_the_post_thumbnail_url($post->ID, 'blog-thumb');
		$post_date=get_the_date();
		$blogInfo = array(
	    'id'=>$blog_post_id,
	    'title'=>$blogTitle,
	    'author'=>$author,
	    'post_date'=>$post_date,
	      'slug'=>$slug,
	    'feature_image'=>$blog_img_url
	    );
		$blogInfoArray[]=$blogInfo;
		endwhile;
		$post_count = 0;
		wp_reset_postdata();
		}
		$msg="Latest 2 post";
	}
	//our blog section end


    $param = array('status'=>1,'message'=>$msg,'blog'=>$blogInfoArray,'total_post'=>$post_count);
	echo json_encode($param);
	exit();
	
}

function get_blog_cat_data($data)
{
	global $post;
	$featuredPostArray= array();
	$categoriesArr=array();
	$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
	if ($data['id']) {
		$paged=$data['id'];
	}else{
		$paged=1;
	}
	$cat_slug=$data['category_slug'];
	$catObj = get_category_by_slug($cat_slug); 
	$catName = $catObj->name;
	$posts_per_page=5;
	//our blog section start
	$blogInfoArray= array();

	$blogargs = array( 'post_type' => 'post', 'post_status' => 'publish', 'order' => 'DESC', 'posts_per_page' => $posts_per_page, 'paged' => $paged, 'category_name' => $cat_slug);
	$blog_query = new WP_Query( $blogargs );
	$post_count = $blog_query->found_posts;
	 if ( $blog_query->have_posts() ) { 
	 while ( $blog_query->have_posts() ) : $blog_query->the_post(); 
	 $blogTitle=get_the_title();
	 $blogTitle = html_entity_decode($blogTitle , ENT_COMPAT, 'UTF-8');
	 $blog_post_id=$post->ID;
	 $slug = $post->post_name;
     $custom_author=get_field('author_name',$post->ID);
     if ($custom_author) {
        $author=$custom_author;
     }else{
        $author=get_the_author();
     }
	 $blog_img_url=get_the_post_thumbnail_url($post->ID, 'blog-thumb-small');
	 $post_date=get_the_date();
	 $shortDesc=get_the_excerpt();
	 $blogInfo = array(
	    'id'=>$blog_post_id,
	    'title'=>$blogTitle,
	    'author'=>$author,
	    'post_date'=>$post_date,
		'short_desc'=>$shortDesc,
	    'slug'=>$slug,
	    'feature_image'=>$blog_img_url
	    );
	$blogInfoArray[]=$blogInfo;
	endwhile;
	$total_pages = $blog_query->max_num_pages;

   if ($total_pages > 1){

    $current_page = $paged;
	$pagination_url=site_url().'wp-json/api/v1/blog';
    $custom_pagination= paginate_links(array(
        'base' => $pagination_url. '%_%',
        'format' => '/%#%',
        'current' => $current_page,
        'total' => $total_pages,
        'mid_size'=> 8,
        'prev_next' => true,
        'prev_text' => __('Previous'),
        'next_text' => __('Next'),
    	));
	}
	wp_reset_postdata();
	$msg="Get blog content";
	}elseif ($post_count==0 && $search) {
		$msg="post not found";
	}
	//our blog section end

	//Get List of Featured Post
	$args = array(
		'post_type' => 'post', 
		'post_status' => 'publish', 
		'order' => 'DESC', 
		'posts_per_page' => 3,
		'meta_query' => array(
			array(
				'key' => 'featured_post',
				'value' => 'featured',
				'compare' => 'LIKE'
				
			),
		),
	);
	$featuredBlogQuery = new WP_Query( $args );
	if ( $featuredBlogQuery->have_posts() ) { 
		while ( $featuredBlogQuery->have_posts() ) : $featuredBlogQuery->the_post(); 
		$blogTitle=get_the_title();
		$blogTitle = html_entity_decode($blogTitle , ENT_COMPAT, 'UTF-8');
		$blog_post_id=$post->ID;
		$slug = $post->post_name;
		$blogInfoFeatured = array(
		'id'=>$blog_post_id,
		'title'=>$blogTitle,
		'slug'=>$slug
		);
	$featuredPostArray[]=$blogInfoFeatured;
	endwhile;

	}
	wp_reset_postdata();

	//Get List of Categories and its count
	$args = array(
		'orderby' => 'slug',
		'parent' => 0
	);
	$categories = get_categories( $args );
	foreach( $categories as $category ){
		$categoriesArr[]=array(
			'id'=>$category->term_id,
			'name'=>$category->name,
			'slug'=>$category->slug,
		);
	 
	}


    $param = array('status'=>1,'message'=>$msg,'categoryName'=>$catName, 'bloginfo'=>$blogInfoArray, 'feturedPost'=>$featuredPostArray, 'categories'=>$categoriesArr, 'total_post'=>$post_count,);
	echo json_encode($param);
	exit();
}

function get_blog_searchdata($data)
{
	global $post;
	$featuredPostArray= array();
	$categoriesArr=array();
	$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
	if ($data['id']) {
		$paged=$data['id'];
	}else{
		$paged=1;
	}
	$search=$data['search'];
	$posts_per_page=5;
	//our blog section start
	$blogInfoArray= array();

	$blogargs = array( 'post_type' => 'post', 'post_status' => 'publish', 'order' => 'DESC', 'posts_per_page' => $posts_per_page, 'paged' => $paged, 's' => $search);
	$blog_query = new WP_Query( $blogargs );
	$post_count = $blog_query->found_posts;
	 if ( $blog_query->have_posts() ) { 
	 while ( $blog_query->have_posts() ) : $blog_query->the_post(); 
	 $blogTitle=get_the_title();
	 $blogTitle = html_entity_decode($blogTitle , ENT_COMPAT, 'UTF-8');
	 $blog_post_id=$post->ID;
	 $slug = $post->post_name;
     $custom_author=get_field('author_name',$post->ID);
     if ($custom_author) {
        $author=$custom_author;
     }else{
        $author=get_the_author();
     }
	 $blog_img_url=get_the_post_thumbnail_url($post->ID, 'blog-thumb-small');
	 $post_date=get_the_date();
	 $shortDesc=get_the_excerpt();
	 $blogInfo = array(
	    'id'=>$blog_post_id,
	    'title'=>$blogTitle,
	    'author'=>$author,
	    'post_date'=>$post_date,
		'short_desc'=>$shortDesc,
	    'slug'=>$slug,
	    'feature_image'=>$blog_img_url
	    );
	$blogInfoArray[]=$blogInfo;
	endwhile;
	$total_pages = $blog_query->max_num_pages;

   if ($total_pages > 1){

    $current_page = $paged;
	$pagination_url=site_url().'wp-json/api/v1/blog';
    $custom_pagination= paginate_links(array(
        'base' => $pagination_url. '%_%',
        'format' => '/%#%',
        'current' => $current_page,
        'total' => $total_pages,
        'mid_size'=> 8,
        'prev_next' => true,
        'prev_text' => __('Previous'),
        'next_text' => __('Next'),
    	));
	}
	wp_reset_postdata();
	$msg="Get blog content";
	}elseif ($post_count==0 && $search) {
		$msg="post not found";
	}
	//our blog section end

	//Get List of Featured Post
	$args = array(
		'post_type' => 'post', 
		'post_status' => 'publish', 
		'order' => 'DESC', 
		'posts_per_page' => 3,
		'meta_query' => array(
			array(
				'key' => 'featured_post',
				'value' => 'featured',
				'compare' => 'LIKE'
				
			),
		),
	);
	$featuredBlogQuery = new WP_Query( $args );
	if ( $featuredBlogQuery->have_posts() ) { 
		while ( $featuredBlogQuery->have_posts() ) : $featuredBlogQuery->the_post(); 
		$blogTitle=get_the_title();
		$blogTitle = html_entity_decode($blogTitle , ENT_COMPAT, 'UTF-8');
		$blog_post_id=$post->ID;
		$slug = $post->post_name;
		$blogInfoFeatured = array(
		'id'=>$blog_post_id,
		'title'=>$blogTitle,
		'slug'=>$slug
		);
	$featuredPostArray[]=$blogInfoFeatured;
	endwhile;

	}
	wp_reset_postdata();

	//Get List of Categories and its count
	$args = array(
		'orderby' => 'slug',
		'parent' => 0
	);
	$categories = get_categories( $args );
	foreach( $categories as $category ){
		$categoriesArr[]=array(
			'id'=>$category->term_id,
			'name'=>$category->name,
			'slug'=>$category->slug,
		);
	 
	}


    $param = array('status'=>1,'message'=>$msg,'bloginfo'=>$blogInfoArray, 'feturedPost'=>$featuredPostArray, 'categories'=>$categoriesArr, 'total_post'=>$post_count,);
	echo json_encode($param);
	exit();
	
}

function get_inx_blog_data($data)
{
	global $post;
 
	$posts_per_page=6;
	//our blog section start
	$blogInfoRecentPostArray= array();
	$blogInfoSinglArray= array();
	$blogCatArray= array();
	$popularPostArray= array();
	$categoriesArr=array();
	$topicArr=array();
	$blogargs = array( 'post_type' => 'post', 'post_status' => 'publish', 'order' => 'DESC', 'posts_per_page' => $posts_per_page);
	$blog_query = new WP_Query( $blogargs );
	//$post_count = $blog_query->found_posts;
	 if ( $blog_query->have_posts() ) { 
	$i=1;
	 while ( $blog_query->have_posts() ) : $blog_query->the_post(); 
	 $blogTitle=get_the_title();
	 $blogTitle = html_entity_decode($blogTitle , ENT_COMPAT, 'UTF-8');
	 $blog_post_id=$post->ID;
	 $slug = $post->post_name;
     $custom_author=get_field('author_name',$post->ID);
     if ($custom_author) {
        $author=$custom_author;
     }else{
        $author=get_the_author();
     }
	$getCatArray= get_cat_data( $post->ID );
	// $catArray=get_the_category( $post->ID );
	// foreach($catArray as $cat){
	// $blogCatArray[]=$cat->cat_name;
	// }
	// $catName = implode(', ', $blogCatArray);
	//Get Single Post
	if($i==1){
	$blog_img_big_url=get_the_post_thumbnail_url($post->ID, 'blog-thumb-big');
	$post_date=get_the_date();
	$shortDesc=get_the_excerpt();
	$blogInfoSingle = array(
	    'id'=>$blog_post_id,
	    'title'=>$blogTitle,
	    'author'=>$author,
	    'post_date'=>$post_date,
		'short_desc'=>$shortDesc,
		'category'=>$getCatArray,
	    'slug'=>$slug,
	    'feature_image'=>$blog_img_big_url
	    );
	$blogInfoSinglArray[]=$blogInfoSingle;
	}
	//Get list of Recent Post
	else{
	$blog_img_small_url=get_the_post_thumbnail_url($post->ID, 'blog-thumb-small');
	$post_date=get_the_date();
	$blogInfo = array(
		'id'=>$blog_post_id,
		'title'=>$blogTitle,
		'author'=>$author,
		'post_date'=>$post_date,
		'category'=>$getCatArray,
		'slug'=>$slug,
		'feature_image'=>$blog_img_small_url
		);
	$blogInfoRecentPostArray[]=$blogInfo;
	}
	$i++;
	endwhile;
	$total_pages = $blog_query->max_num_pages;
}
wp_reset_postdata();
//Get List of Popular Post
	$args = array(
		'post_type' => 'post', 
		'post_status' => 'publish', 
		'order' => 'DESC', 
		'posts_per_page' => 2,
		'meta_query' => array(
			array(
				'key' => 'popular_post',
				'value' => 'popular',
				'compare' => 'LIKE'
				
			),
		),
	);
	$popularBlogQuery = new WP_Query( $args );
	if ( $popularBlogQuery->have_posts() ) { 
		while ( $popularBlogQuery->have_posts() ) : $popularBlogQuery->the_post(); 
		$blogTitle=get_the_title();
		$blogTitle = html_entity_decode($blogTitle , ENT_COMPAT, 'UTF-8');
		$shortDesc=get_the_excerpt();
		$blog_post_id=$post->ID;
		$slug = $post->post_name;
		$custom_author=get_field('author_name',$post->ID);
		if ($custom_author) {
		   $author=$custom_author;
		}else{
		   $author=get_the_author();
		}
		$getCatArray= get_cat_data( $post->ID );
	//    $catArray=get_the_category( $post->ID );
	//    foreach($catArray as $cat){
	//    $blogCatArray[]=$cat->cat_name;
	//    }
	//    $catName = implode(', ', $blogCatArray);
	   $blog_img_popular_url=get_the_post_thumbnail_url($post->ID, 'blog-thumb-popular');
	   $post_date=get_the_date();
	   $shortDesc=get_the_excerpt();
	   $blogInfoPopular = array(
		   'id'=>$blog_post_id,
		   'title'=>$blogTitle,
		   'author'=>$author,
		   'post_date'=>$post_date,
		   'short_desc'=>$shortDesc,
		   'category'=>$getCatArray,
		   'slug'=>$slug,
		   'feature_image'=>$blog_img_popular_url
		   );
	   $popularPostArray[]=$blogInfoPopular;
	   endwhile;

	   wp_reset_postdata();
	}
	//Get List of Trending Post
		$args = array(
			'post_type' => 'post', 
			'post_status' => 'publish', 
			'order' => 'DESC', 
			'posts_per_page' => 4,
			'meta_query' => array(
				array(
					'key' => 'trending_post',
					'value' => 'trending',
					'compare' => 'LIKE'
					
				),
			),
		);
	$trendingBlogQuery = new WP_Query( $args );
	if ( $trendingBlogQuery->have_posts() ) { 
		while ( $trendingBlogQuery->have_posts() ) : $trendingBlogQuery->the_post(); 
		$blogTitle=get_the_title();
		$blogTitle = html_entity_decode($blogTitle , ENT_COMPAT, 'UTF-8');
		$shortDesc=get_the_excerpt();
		$blog_post_id=$post->ID;
		$slug = $post->post_name;
		$custom_author=get_field('author_name',$post->ID);
		if ($custom_author) {
		   $author=$custom_author;
		}else{
		   $author=get_the_author();
		}
		  $getCatArray= get_cat_data( $post->ID );
	//    $catArray=get_the_category( $post->ID );
	//    foreach($catArray as $cat){
	//    $blogCatArray[]=$cat->cat_name;
	//    }
	//    $catName = implode(', ', $blogCatArray);
	   $blog_img_popular_url=get_the_post_thumbnail_url($post->ID, 'blog-thumb-popular');
	   $post_date=get_the_date();
	   $shortDesc=get_the_excerpt();
	   $blogInfoTrending = array(
		   'id'=>$blog_post_id,
		   'title'=>$blogTitle,
		   'author'=>$author,
		   'post_date'=>$post_date,
		   'short_desc'=>$shortDesc,
		   'category'=>$getCatArray,
		   'slug'=>$slug,
		   'feature_image'=>$blog_img_popular_url
		   );
	   $trendingPostArray[]=$blogInfoTrending;
	   endwhile;

	}
//Get List of Categories and its count
	$args = array(
		'orderby' => 'slug',
		'parent' => 0
	);
	$categories = get_categories( $args );
	foreach( $categories as $category ){
		$categoriesArr[]=array(
			'id'=>$category->term_id,
			'name'=>$category->name,
			'count'=>$category->category_count,
			'slug'=>$category->slug,
		);
	 
	}

//Get Extra Topic and its URL
if( have_rows('topics', 5581) ){
	while( have_rows('topics', 5581) ): the_row();
	$topicArr[]=array(
		'name'=>get_sub_field('name', 5581),
		'url'=>get_sub_field('url', 5581),
		'icon_url'=>get_sub_field('icon_url', 5581),
	);
	endwhile;
}

	$msg="Get blog content";
	//our blog section end
    $param = array(
		'status'=>1,
		'message'=>$msg, 
		'singleBlog'=>$blogInfoSinglArray, 
		'recentBlog'=>$blogInfoRecentPostArray, 
		'popularPost'=>$popularPostArray, 
		'trendingPost'=>$trendingPostArray, 
		'categories'=>$categoriesArr,
		'topics'=>$topicArr
	);
	echo json_encode($param);
	exit();
	
}

function get_blogcat_data()
{
$args = array("hide_empty" => 0,
        "type"      => "post",      
        "orderby"   => "name",
        "order"     => "ASC" );
$types = get_categories($args);
$param = array('status'=>1,'message'=>$msg,'category'=>$types);
echo json_encode($param);
exit(); 
}

function get_career_data()
{
	global $post;
	//our locaton section start
	$careerInfoArray= array();

	$careerargs = array( 'post_type' => 'career_type', 'post_status' => 'publish', 'order' => 'DESC', 'posts_per_page' => 4);
	$career_query = new WP_Query( $careerargs );
	 if ( $career_query->have_posts() ) : 
	 while ( $career_query->have_posts() ) : $career_query->the_post(); 
	 $my_technology= array();
	 $careerTitle=get_the_title();
	 $career_post_id=$post->ID;
	 //$career_exp=get_the_content();
	 $career_exp=get_field('add_experience_years',$career_post_id);
    if(get_field('technology',$post_id)):
    	 while(has_sub_field('technology',$post_id)):
    	 	if (strlen(get_sub_field('technology_name',$post_id)) > 0 && strlen(trim(get_sub_field('technology_name',$post_id))) > 0){
    	 	$my_technology[] = get_sub_field('technology_name',$post_id);
    	 }
    	 endwhile;
    endif;
	 
	 $careerInfo = array(
	    'id'=>$career_post_id,
	    'title'=>$careerTitle,
	    'experience'=>$career_exp,
	    'technology'=>$my_technology
	    );
	$careerInfoArray[]=$careerInfo;
	endwhile;
	wp_reset_postdata();
	endif;
//our locaton section end
	$msg="Get career post";
    $param = array('status'=>1,'message'=>$msg,'career'=>$careerInfoArray);
	echo json_encode($param);
	exit();
}

function get_career_details_data($data)
{
	global $post;
	$post_id=$data['id'];
	 
	 $careerTitle=get_the_title($post_id);
	 $career_post_id=$post_id;
	 $career_exp=get_field('add_experience_years',$post_id);
	 $no_of_openings=get_field('no_of_openings',$post_id);
	 if(get_field('technology',$post_id)):
    	 while(has_sub_field('technology',$post_id)):
    	 	if (strlen(get_sub_field('technology_name',$post_id)) > 0 && strlen(trim(get_sub_field('technology_name',$post_id))) > 0){
    	 	$my_technology[] = get_sub_field('technology_name',$post_id);
    	 }
    	 endwhile;
    endif;

    $location=get_field('location',$post_id);
	if(get_field('roles_responsibilities',$post_id)):
    	 while(has_sub_field('roles_responsibilities',$post_id)):
    	 	if (strlen(get_sub_field('roles',$post_id)) > 0 && strlen(trim(get_sub_field('roles',$post_id))) > 0){
    	 		$roles[] = get_sub_field('roles',$post_id);
    	 	}
    	 	
    	 endwhile;
    endif;

    if(get_field('requirements',$post_id)):
    	 while(has_sub_field('requirements',$post_id)):
    	 	if (strlen(get_sub_field('job_requirements',$post_id)) > 0 && strlen(trim(get_sub_field('job_requirements',$post_id))) > 0){
    	 	$requirements[] = get_sub_field('job_requirements',$post_id);
    	 }
    	 endwhile;
    endif;

	$careerInfo = array(
	    'id'=>$career_post_id,
	    'title'=>$careerTitle,
	    'experience'=>$career_exp,
	    'technology'=>$my_technology,
	    'openings'=>$no_of_openings,
	    'location'=>$location,
	    'roles'=>$roles,
	    'requirements'=>$requirements

	);
	
//our locaton section end
	$msg="Get career post";
    $param = array('status'=>1,'message'=>$msg,'career'=>$careerInfo);
	echo json_encode($param);
	exit();
}

function get_gallery_data()
{
	global $post;
	//our locaton section start
	$galleryinfoArray= array();
	$galleryargs = array( 'post_type' => 'gallery_type', 'post_status' => 'publish', 'order' => 'DESC', 'posts_per_page' => 8);
	$gallery_query = new WP_Query( $galleryargs );
	 if ( $gallery_query->have_posts() ) : 
	 while ( $gallery_query->have_posts() ) : $gallery_query->the_post(); 
	 $gallery_post_id=$post->ID; 
	 $gallery_img_url=get_the_post_thumbnail_url($post->ID, 'full');
	 $galleryInfo = array(
	    'id'=>$gallery_post_id,
	    'gallery_image'=>$gallery_img_url
	    );
	$galleryinfoArray[]=$galleryInfo;
	endwhile;
	wp_reset_postdata();
	endif;
//our locaton section end
	$msg="Get gallery images";
    $param = array('status'=>1,'message'=>$msg,'gallery'=>$galleryinfoArray);
	echo json_encode($param);
	exit();
}

function get_faq_data($data)
{
	global $post;
	$cat_slug=$data['category_slug'];
	//our locaton section start
	$faqinfoArray= array();
	$faqargs = array( 'post_type' => 'faq_type', 'post_status' => 'publish', 'order' => 'DESC', 'posts_per_page' => 10, 'category_name' => $cat_slug);
	$faq_query = new WP_Query( $faqargs );
	 if ( $faq_query->have_posts() ) { 
	 while ( $faq_query->have_posts() ) : $faq_query->the_post(); 
	 $faq_post_id=$post->ID; 
	 $faq_title=get_the_title();
	 $faq_content=get_the_content();
	 $faqInfo = array(
	    'id'=>$faq_post_id,
	    'faq_title'=>$faq_title,
	    'faq_content'=>$faq_content
	    );
	$faqinfoArray[]=$faqInfo;
	endwhile;
	wp_reset_postdata();
	$msg="Get Faq content";
	} else{
		$faqargs = array( 'post_type' => 'faq_type', 'post_status' => 'publish', 'order' => 'DESC', 'posts_per_page' => 10);
		$faq_query = new WP_Query( $faqargs );
		 if ( $faq_query->have_posts() ) { 
		 while ( $faq_query->have_posts() ) : $faq_query->the_post(); 
		 $faq_post_id=$post->ID; 
		 $faq_title=get_the_title();
		 $faq_content=get_the_content();
		 $faqInfo = array(
		    'id'=>$faq_post_id,
		    'faq_title'=>$faq_title,
		    'faq_content'=>$faq_content
		    );
		$faqinfoArray[]=$faqInfo;
		endwhile;
		wp_reset_postdata();
		$msg="Get latest 5 Faq content";
	}

	}
	//our locaton section end
	
    $param = array('status'=>1,'message'=>$msg,'faq'=>$faqinfoArray);
	echo json_encode($param);
	exit();
}


function get_contactinfo_data()
{
	$contactInfo = array(
	    'phone'=>get_option('inx_phone_num'),
	    'alt_phone'=>get_option('inx_alt_phone_num'),
	    'contact_email'=>get_option('inx_contact_email'),
	    'hr_email'=>get_option('inx_hr_email')
    );
	$msg="Get contact Info";
	$param = array('status'=>1,'message'=>$msg,'contactinfo'=>$contactInfo);
	echo json_encode($param);
	exit();
}

function get_subscription_data()
{
	 global $wpdb;
	//Get data from POST
	$email=trim($_POST['email']);
	$table = $wpdb->prefix.'inx_subscription';
	$subject='New subscriptions Request';

	if (!$email) {
		$msg = "Please enter email";
	    $param = array('status'=>0,'message'=>$msg); 
	}elseif(!filter_var($email, FILTER_VALIDATE_EMAIL)){
		$msg = "Please enter valid email id";
	    $param = array('status'=>0,'message'=>$msg); 
	}else{

		$existingSignup = $wpdb->get_results("SELECT COUNT(*) as emailCount FROM $table WHERE email='$email'");
		$email_count=$existingSignup['0']->emailCount;
		if ($email_count>0) {
		$msg = "This email is already subscribed";
	    $param = array('status'=>0,'message'=>$msg);
		}else{

		$data = array('email' => $email, 'type' => 1);
		$format = array('%s','%d');
		$wpdb->insert($table,$data,$format);

		// Sent email for subscribed user                               
		$email_subject = $subject;
		$messages="<table cellspacing='0' cellpadding='0' width='100%' border='0'>
	      <tr style='background-color:#24620C;color:#fff;font-family: sans-serif;font-size: 82%;'>
	        <td align='center' colspan='4'>
	          <h3 style='margin-top:10px;'>New subscriptions details<h3>
	        </td>
	      </tr/>
	      <tr><td colspan='4'>&nbsp;</td></tr>
	      <tr><td colspan='4'>&nbsp;</td></tr>
	      <tr>
	        <td width='5%'></td>
	        <td width='25%'><b>Email</b></td>
	        <td width='5%'><b>:</b></td>
	        <td>".$email."</td>
	      </tr>
	      <tr><td colspan='4'>&nbsp;</td></tr>
	      <tr><td colspan='4'>&nbsp;</td></tr>
	      </table>";
	      $headers = 'MIME-Version: 1.0' . "\r\n";
	      $headers.= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
	      $headers.= 'From: '. $email . "\r\n";
	      //$admin_email = get_option( 'admin_email' );
	      $admin_email =get_option('inx_contact_email');
	        
	      if(wp_mail($admin_email,$subject,$messages,$headers)) {
	                $msg = "you have subscribed successfully";
	                $param = array('status'=>1,'message'=>$msg);
	               
	            } else {
	                $msg = "Email could not be sent";
	                $param = array('status'=>0,'message'=>$msg);  
	        }

		}	
	}

		echo json_encode($param);
		exit();

}

function get_blogdetails_data($data)
{
    
	global $post;
	$page_slug=$data['slug'];
    $args = array(
      'name'        => $page_slug,
      'post_type'   => 'post',
      'post_status' => 'publish',
      'numberposts' => 1
    );
    $my_posts = get_posts($args);
    if( $my_posts ) {
      $post_id= $my_posts[0]->ID;
    }
	if ($post_id) {
	$auth = get_post($post_id);
	$authid = $auth->post_author;
	$blogTitle=get_the_title($post_id);
	$blogTitle = html_entity_decode($blogTitle , ENT_COMPAT, 'UTF-8');
	 
	$user_first_name = get_the_author_meta('first_name',$authid);
	$user_last_name = get_the_author_meta('last_name',$authid); 
	$custom_author=get_field('author_name',$post_id);
	$seo_title=get_field('seo_title',$post_id);
	$seo_keyword=get_field('seo_keyword',$post_id);
	$seo_description=get_field('seo_description',$post_id);
	if ($custom_author) {
	 	$author=$custom_author;
	}else{
	 	$author=$user_first_name.' '.$user_last_name;
	} 
	
	$blog_img_url=get_the_post_thumbnail_url($post_id, 'full');
	$post_content=$auth->post_content;
	$val = array("\n","\r","\t");
	$post_content = str_replace($val, "", $post_content);
	//$post_content =stripslashes($post_content);
	//$post_content = html_entity_decode($post_content , ENT_COMPAT, 'UTF-8');
	//$post_content= strip_tags($post_content);
	$blogInfo = array(
	    'id'=>$post_id,
	    'title'=>$blogTitle,
	    'author'=>$author,
	    'feature_image'=>$blog_img_url,
	    'content'=>$post_content,
		'seo_title'=>$seo_title,
		'seo_keyword'=>$seo_keyword,
		'seo_description'=>$seo_description
	    );
	$msg="Get Blog details Info";
	$param = array('status'=>1,'message'=>$msg,'contactinfo'=>$blogInfo);
	} else{
	$msg="Please pass correct post id";
	$param = array('status'=>0,'message'=>$msg,'contactinfo'=>$blogInfo);
	}
	echo json_encode($param,JSON_UNESCAPED_SLASHES);
	exit();
}

function get_inxblogdetails_data($data)
{
    $featuredPostArray=Array();
	$blogFeatured=Array();
	$relatedPostArray=Array();
	$categoriesArr=Array();
	$blogCatArray=Array();
	global $post;
	$page_slug=$data['slug'];
    $args = array(
      'name'        => $page_slug,
      'post_type'   => 'post',
      'post_status' => 'publish',
      'numberposts' => 1
    );
    $my_posts = get_posts($args);
    if( $my_posts ) {
      $post_id= $my_posts[0]->ID;
    }
	if ($post_id) {
	//Get post categories
	$getCatArray= get_cat_data( $post_id );
	// $catArray=get_the_category( $post_id );
	// foreach($catArray as $cat){
	// $blogCatArray[]=$cat->cat_name;
	// }
	// $catName = implode(', ', $blogCatArray);
	//Get post Details
	$auth = get_post($post_id);
	$authid = $auth->post_author;
	$blogTitle=get_the_title($post_id);
	$blogTitle = html_entity_decode($blogTitle , ENT_COMPAT, 'UTF-8');
	 
	$user_first_name = get_the_author_meta('first_name',$authid);
	$user_last_name = get_the_author_meta('last_name',$authid); 
	$custom_author=get_field('author_name',$post_id);
	$seo_title=get_field('seo_title',$post_id);
	$seo_keyword=get_field('seo_keyword',$post_id);
	$seo_description=get_field('seo_description',$post_id);
	if ($custom_author) {
	 	$author=$custom_author;
	}else{
	 	$author=$user_first_name.' '.$user_last_name;
	} 
	
	$blog_img_url=get_the_post_thumbnail_url($post_id, 'full');
	$post_content=$auth->post_content;
	$cta_content='<div style="background: #00c5de;padding: 30px 0;text-align: center;margin: 25px 0;">
	<h3 style="font-size: 20px;color: #fff;margin-top: -15px;">
	  Create Next-Gen Web & Mobile Apps With InheritX Solutions
	</h3>
	<a href="https://www.inheritx.com/contact-us">
	  <button style="background: #ffc107;padding: 5px 15px;height: 45px;border: none;border-radius: 6px;color: #000;font-size: 16px;font-weight: bold;margin-bottom: -10px;margin-top: 5px;">
	  Contact Experts
	  </button></a>
	</div>';
// 	$cta_content=json_encode($cta_content);
	$post_content=$post_content;
	$val = array("\n","\r","\t");
	$post_content = str_replace($val, "", $post_content);

	$new_cta_content = str_replace($val, "", $cta_content);

	//$post_content =stripslashes($post_content);
	//$post_content = html_entity_decode($post_content , ENT_COMPAT, 'UTF-8');
	//$post_content= strip_tags($post_content);
	$blogInfo = array(
	    'id'=>$post_id,
	    'title'=>$blogTitle,
		'category'=>$getCatArray,
	    'author'=>$author,
	    'feature_image'=>$blog_img_url,
	    'content'=>$post_content,
		'seo_title'=>$seo_title,
		'seo_keyword'=>$seo_keyword,
		'seo_description'=>$seo_description,
		'cta_content'=>$new_cta_content
	    );

	//Get List of Featured Post
	$args = array(
		'post_type' => 'post', 
		'post_status' => 'publish', 
		'order' => 'DESC', 
		'posts_per_page' => 3,
		'meta_query' => array(
			array(
				'key' => 'featured_post',
				'value' => 'featured',
				'compare' => 'LIKE'
				
			),
		),
	);
	$featuredBlogQuery = new WP_Query( $args );
	if ( $featuredBlogQuery->have_posts() ) { 
		while ( $featuredBlogQuery->have_posts() ) : $featuredBlogQuery->the_post(); 
		$blogTitle=get_the_title();
		$blogTitle = html_entity_decode($blogTitle , ENT_COMPAT, 'UTF-8');
		$blog_post_id=$post->ID;
		$slug = $post->post_name;
		$blogInfoFeatured = array(
		'id'=>$blog_post_id,
		'title'=>$blogTitle,
		'slug'=>$slug
		);
	$featuredPostArray[]=$blogInfoFeatured;
	endwhile;

	}
	wp_reset_postdata();
	// Default arguments
	$args = array(
		'posts_per_page' => 4, // How many items to display
		'post__not_in'   => array( get_the_ID() ), // Exclude current post
		'no_found_rows'  => true, // We don't ned pagination so this speeds up the query
	);

	// Check for current post category and add tax_query to the query arguments 
	$cats=get_the_category( $post_id );
	$cats_ids = array();  
	foreach( $cats as $wpex_related_cat ) {
		$cats_ids[] = $wpex_related_cat->term_id; 
	}
	if ( ! empty( $cats_ids ) ) {
		$args['category__in'] = $cats_ids;
	}
	// Query posts
	$wpex_query = new wp_query( $args );
	// Loop through posts
	while ( $wpex_query->have_posts() ) : $wpex_query->the_post();
	$realtedPost[]=get_the_title();
	$blogTitle=get_the_title();
	$blogTitle = html_entity_decode($blogTitle , ENT_COMPAT, 'UTF-8');
	$blog_post_id=$post->ID;
	$slug = $post->post_name;
	$relatedPostArray[] = array(
		'id'=>$blog_post_id,
		'title'=>$blogTitle,
		'slug'=>$slug
		);
	// End loop
	endwhile;
	// Reset post data
	wp_reset_postdata();

	//Get List of Categories and its count
	$args = array(
		'orderby' => 'slug',
		'parent' => 0
	);
	$categories = get_categories( $args );
	foreach( $categories as $category ){
		$categoriesArr[]=array(
			'id'=>$category->term_id,
			'name'=>$category->name,
			'slug'=>$category->slug,
		);
	 
	}
	
	$msg="Get Live Blog details Info";
	$param = array('status'=>1,'message'=>$msg,'bloginfo'=>$blogInfo,'feturedPost'=>$featuredPostArray, 'relatedPost'=>$relatedPostArray, 'categories'=>$categoriesArr);
	} else{
	$msg="Please pass correct post id";
	$param = array('status'=>0,'message'=>$msg,'bloginfo'=>$blogInfo);
	}
	echo json_encode($param,JSON_UNESCAPED_SLASHES);
	exit();
}

//our team section start
function get_teaminfo_data($data)
{

$teamInfoArray= array();
$teamargs = array( 'post_type' => 'team_type', 'post_status' => 'publish', 'order' => 'ASC', 'posts_per_page' => -1);
$team_query = new WP_Query( $teamargs );
 if ( $team_query->have_posts() ) : 
 while ( $team_query->have_posts() ) : $team_query->the_post(); 
 $teamTitle=get_the_title();
 $team_post_id=get_the_ID();
 $team_img_url=get_the_post_thumbnail_url($post->ID, 'full');
 //$teamDesignation=get_post_meta($post->ID, 'designation', true);
 $teamDesignation=get_field('designation');
 
 $teamInfo = array(
    'id'=>$team_post_id,
    'title'=>$teamTitle,
    'feature_image'=>$team_img_url,
    'designation'=>$teamDesignation
    );
$teamInfoArray[]=$teamInfo;
endwhile;
wp_reset_postdata();
endif;

$msg="Get team info content";
$param = array('status'=>1,'message'=>$msg,'teamsdata'=>$teamInfoArray);
echo json_encode($param);
exit();
}
//our Team section end
add_action( 'rest_api_init', function () {
  header( "Access-Control-Allow-Origin: *" );
  register_rest_route( 'api', '/home', array(
    'methods' => 'GET',
    'callback' => 'my_home_page_content',
  ) );

  register_rest_route( 'api', '/locations', array(
    'methods' => 'GET',
    'callback' => 'get_locations',
  ) );

 register_rest_route( 'api', '/portfolio', array(
    'methods' => 'GET',
    'callback' => 'get_portfolio',
  ) );

register_rest_route( 'api', '/portfolio/(?P<id>\d+)', array(
    'methods'  => 'GET',
    'callback' => 'get_portfolio'
));

register_rest_route( 'api', '/portfolio/(?P<category_slug>[a-zA-Z0-9-]+)/(?P<id>\d+)', array(
    'methods'  => 'GET',
    'callback' => 'get_portfolio'

));

register_rest_route( 'api', '/portfolio/(?P<category_slug>[a-zA-Z0-9-]+)', array(
    'methods'  => 'GET',
    'callback' => 'get_portfolio'

));

 register_rest_route( 'api', '/contactform', array(
    'methods' => 'POST',
    'callback' => 'send_form_deta'
));

register_rest_route( 'api/v1', '/careerform', array(
    'methods' => 'POST',
    'callback' => 'send_careerform_data'
));

register_rest_route( 'api/v1', '/blog/', array(
    'methods'  => WP_REST_Server::READABLE,
    'callback' => 'get_blog_data'
));
register_rest_route( 'api/v1', '/inxblog/', array(
    'methods'  => WP_REST_Server::READABLE,
    'callback' => 'get_inx_blog_data'
));
register_rest_route( 'api/v1', '/blog/(?P<id>\d+)', array(
    'methods'  => WP_REST_Server::READABLE,
    'callback' => 'get_blog_data'
));

register_rest_route( 'api/v1', '/blogsearch/(?P<id>\d+)', array(
    'methods'  => WP_REST_Server::READABLE,
    'callback' => 'get_blog_searchdata'
));

register_rest_route( 'api/v1', '/blog/(?P<category_slug>\d+)', array(
    'methods'  => WP_REST_Server::READABLE,
    'callback' => 'get_blog_data'
));

register_rest_route( 'api/v1', '/inxblog/(?P<id>\d+)', array(
    'methods'  => WP_REST_Server::READABLE,
    'callback' => 'get_blog_cat_data'
));

register_rest_route( 'api/v1', '/blogcat/', array(
    'methods'  => WP_REST_Server::READABLE,
    'callback' => 'get_blogcat_data'
));

register_rest_route( 'api/v1', '/career/', array(
    'methods'  => WP_REST_Server::READABLE,
    'callback' => 'get_career_data'
));

register_rest_route( 'api/v1', '/careerdetails/(?P<id>\d+)', array(
    'methods'  => WP_REST_Server::READABLE,
    'callback' => 'get_career_details_data'
));

register_rest_route( 'api/v1', '/gallery/', array(
    'methods'  => WP_REST_Server::READABLE,
    'callback' => 'get_gallery_data'
));

register_rest_route( 'api/v1', '/faq/', array(
    'methods'  => WP_REST_Server::READABLE,
    'callback' => 'get_faq_data'
));
register_rest_route( 'api/v1', '/faq/(?P<category_slug>\d+)', array(
    'methods'  => WP_REST_Server::READABLE,
    'callback' => 'get_faq_data'
));

register_rest_route( 'api/v1', '/contactinfo/', array(
    'methods'  => WP_REST_Server::READABLE,
    'callback' => 'get_contactinfo_data'
));

register_rest_route( 'api/v1', '/subscription/', array(
    'methods'  => 'POST',
    'callback' => 'get_subscription_data'
));

register_rest_route( 'api/v1', '/blogdetails/(?P<slug>[a-zA-Z0-9-]+)', array(
    'methods'  => 'GET',
    'callback' => 'get_blogdetails_data'

));

register_rest_route( 'api/v1', '/inxblogdetails/(?P<slug>[a-zA-Z0-9-]+)', array(
    'methods'  => 'GET',
    'callback' => 'get_inxblogdetails_data'

));

register_rest_route( 'api/v1', '/teaminfo/', array(
    'methods'  => WP_REST_Server::READABLE,
    'callback' => 'get_teaminfo_data'
));
} );


//Featured image validation

add_action('save_post', 'wpds_check_thumbnail');
add_action('admin_notices', 'wpds_thumbnail_error');
 
function wpds_check_thumbnail($post_id) {
 // echo get_post_type($post_id);
	$post_status=get_post_status( $post_id );
	
	if ($post_status!='trash') {
    // change to any custom post type 
    if(get_post_type($post_id) == 'post' || get_post_type($post_id) == 'portfolio_type' || get_post_type($post_id) == 'testimonial_type' || get_post_type($post_id)== 'team_type' || get_post_type($post_id)== 'client_type' || get_post_type($post_id)== 'youtube_testimo_type' || get_post_type($post_id) == 'location_type' || get_post_type($post_id)== 'gallery_type')
        {
     
    if ( !has_post_thumbnail( $post_id ) ) {
        // set a transient to show the users an admin message
        set_transient( "has_post_thumbnail", "no" );
        // unhook this function so it doesn't loop infinitely
        remove_action('save_post', 'wpds_check_thumbnail');
        // update the post set it to draft
        wp_update_post(array('ID' => $post_id, 'post_status' => 'draft'));
 
        add_action('save_post', 'wpds_check_thumbnail');
    } else {
        delete_transient( "has_post_thumbnail" );
    	}
  	}
  }
}
 
function wpds_thumbnail_error()
{
    // check if the transient is set, and display the error message
    if ( get_transient( "has_post_thumbnail" ) == "no" ) {
        echo "<div id='message' class='error'><p><strong>You must select Featured Image. Your Post is saved but it can not be published.</strong></p></div>";
        delete_transient( "has_post_thumbnail" );
    }
 
}

// if you don't add 3 as as 4th argument, this will not work as expected
add_action( 'transition_post_status', 'my_save_post_function', 10, 3 );

function my_save_post_function( $new_status, $old_status, $post ) {
	if ( $new_status == 'publish' && $old_status != 'publish' && $post->post_type=='post') {
 	global $wpdb;
	$year=date("Y");
	$table_name = $wpdb->prefix.'inx_subscription';
 	$emailArrays = $wpdb->get_results("SELECT email FROM $table_name WHERE type='1'");
	$post_title=$post->post_title;
	$featured_img_url = get_the_post_thumbnail_url($post->ID,'full');
	$link='https://www.inheritx.com/blog/'.$post->post_name;
	$post_content =$post->post_content;  
	$post_content = preg_replace("/<img[^>]+\>/i", " ", $post_content);          
	$post_content = apply_filters('the_content', $post_content);
	$post_content = str_replace(']]>', ']]>', $post_content);
	$post_content = substr($post_content, 0, 200);
   	$subject=$post_title;
	$headers = array('Content-Type: text/html; charset=UTF-8');
	foreach ($emailArrays as $key => $emailArray) {
		$user_email=$emailArray->email;
	$message ='<body class="body" style="padding:0 !important; margin:0 !important; display:block !important; min-width:100% !important; width:100% !important; background:#001736; -webkit-text-size-adjust:none;">
	<table width="100%" border="0" cellspacing="0" cellpadding="0" bgcolor="#001736">
		<tr>
			<td align="center" valign="top">
				<table width="0" border="0" cellspacing="0" cellpadding="0" class="mobile-shell">
					<tr>
						<td class="td container" style="width:100%; max-width:650px; font-size:0pt; line-height:0pt; margin:0; font-weight:normal; padding:50px 20px;">
							<!-- Intro -->
							<table width="100%" border="0" cellspacing="0" cellpadding="0">
								<tr>
									<td style="padding-bottom: 0px;">
										<table width="100%" border="0" cellspacing="0" cellpadding="0">
											<tr>
												<td class="tbrr p30-15" style="padding: 50px 40px; border-radius:25px 25px 0px 0px;" bgcolor="#12325c">
													<table width="100%" border="0" cellspacing="0" cellpadding="0">
														<tr>
															<td class="h3 pb20" style="color:#ffffff; font-size:24px; line-height:24px; text-align:left; padding-bottom:0px; font-weight: 600;">'.$post_title.'</td>
														</tr>
													</table>
												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
							<!-- END Intro -->

							<!--Blog-->
							<table width="100%" border="0" cellspacing="0" cellpadding="0" style="">
								<tr>
									<td>
										<table width="100%" border="0" cellspacing="0" cellpadding="0" bgcolor="#0e264b" style="border-radius: 0px 0px 0px 0px;">
											<tr>
												<td class="fluid-img" style="font-size:0pt; line-height:0pt; text-align:left;">
													<img src="'.$featured_img_url.'" alt="Blog_Img" border="0" width="100%" height="" border="0"/>
													 
											</tr>
											<tr>
												<td class="p30-15" style="padding: 30px 30px;">
													<table width="100%" border="0" cellspacing="0" cellpadding="0">
														
														<tr>
															<td class="text pb20" style="color:#ffffff; font-size:18px; line-height:30px; text-align:left; padding-bottom:20px;">'.$post_content.'...</td>
														</tr>
														 
														<tr>
															<td align="center">
																<table border="0" cellspacing="0" cellpadding="0">
																	<tr>
																		<td class="blue-button text-button" style="padding: 10px 0 0">
																			<a href="'.$link.'" target="_blank" class="link-white" style="color:#ffffff; text-decoration:none; background:#00c5de; font-size:14px; line-height:18px; padding:12px 30px; text-align:center; border-radius:20px; font-weight:bold; display: inline-block;">
																				<span class="link-white" style="color:#ffffff; text-decoration:none;">READ MORE</span>
																			</a>
																		</td>
																	</tr>
																</table>
															</td>
														</tr>
													 
													</table>
												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
							<!-- END Blog -->


							<!-- Footer -->
							<table width="100%" border="0" cellspacing="0" cellpadding="0" style="padding: 10px 0 0;">
								<tr>
									<td class="p30-15 bbrr" style="padding: 50px 30px; border-radius:0px 0px 25px 25px; margin: 10px 0 0;" bgcolor="#0e264b">
										<table width="100%" border="0" cellspacing="0" cellpadding="0">
											<tr>
												<td align="center" style="padding-bottom: 30px;">
													<table border="0" cellspacing="0" cellpadding="0">
														<tr>
															<td class="img" width="55" style="font-size:0pt; line-height:0pt; text-align:left;"><a href="https://www.facebook.com/InheritxSolutions/" target="_blank"><img src="https://admin.inheritx.com/wp-content/uploads/2019/11/ico_facebook.jpg" width="38" height="38" border="0" alt="" /></a></td>

															<td class="img" width="55" style="font-size:0pt; line-height:0pt; text-align:left;"><a href="https://twitter.com/inheritx" target="_blank"><img src="https://admin.inheritx.com/wp-content/uploads/2019/11/ico_twitter.jpg" width="38" height="38" border="0" alt="" /></a></td>

															<td class="img" width="55" style="font-size:0pt; line-height:0pt; text-align:left;"><a href="https://www.linkedin.com/company/inheritx-solutions-pvt-ltd/" target="_blank"><img src="https://admin.inheritx.com/wp-content/uploads/2019/11/ico_linkedin.jpg" width="38" height="38" border="0" alt="" /></a></td>

															<td class="img" width="55" style="font-size:0pt; line-height:0pt; text-align:left;"><a href="https://www.instagram.com/inheritxsolutions/" target="_blank"><img src="https://admin.inheritx.com/wp-content/uploads/2019/11/ico_instagram.jpg" width="38" height="38" border="0" alt="" /></a></td>
															
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td class="text-footer1 pb10" style="color:#fff; font-size:14px; line-height:20px; text-align:center; padding-bottom:10px;">Copyright © '.$year.' InheritX Solutions. All Rights Reserved.</td>
											</tr>
											<tr>
												<td class="text-footer2" style="color:#8297b3; font-size:14px; line-height:26px; padding-bottom:10px;text-align:center;">Website:
													<a href="https://www.inheritx.com/" target="_blank" style="color:#fff;"> www.inheritx.com </a>
												</td>
											</tr>
											<tr>
												<td class="text-footer4" style="color:#8297b3; font-size:14px; line-height:26px; text-align:center;">Phone:
													<span style="color:#fff;"> +1 (347) 394-0007 </span>
												</td>
											</tr>
									</td>
								</tr>
								
							</table>
							<tr>
									<td class="text-footer3 p30-15" style="padding: 40px 30px 0px 30px; color:#475c77; font-size:14px; line-height:18px; text-align:center;">
										<a href="https://admin.inheritx.com/?email='.$user_email.'" target="_blank" class="link2-u" style="color:#475c77; text-decoration:underline;"><span class="link2-u" style="color:#475c77; text-decoration:underline;">Unsubscribe</span></a> from this mailing list.
									</td>
								</tr>
							<!-- END Footer -->
						</td>
					</tr>
				</table>
			</td>
		</tr>
	</table>
</body>';
 	wp_mail($user_email,$subject,$message,$headers);
 		}
	}
}

// ADD NEW COLUMN
function ST4_columns_head($columns) {
  unset($columns['author']);
  $new = array();
  foreach($columns as $key => $title) {
    if ($key=='categories'){
      	$new['blog_author'] = 'Author';
      }
      $new[$key] = $title;
  }
  return $new;
}
 
// SHOW THE FEATURED IMAGE
function ST4_columns_content($column_name, $post_ID) {
    if ($column_name == 'blog_author') {
        $post_featured_image = $post_ID;
        $custom_author=get_field('author_name',$post_ID);
		 if ($custom_author) {
		 	$author=$custom_author;
		 }else{
		 	$author=get_the_author();
		 }

		 echo $author; 
       
    }
}

add_filter('manage_posts_columns', 'ST4_columns_head');
add_action('manage_posts_custom_column', 'ST4_columns_content', 10, 2);